/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.applications.trainreservation.actions;

import at.salzburgresearch.applications.trainreservation.actionforms.SelectSeatsForm;
import at.salzburgresearch.applications.trainreservation.datamodel.Coach;
import at.salzburgresearch.applications.trainreservation.datamodel.Reservation;
import at.salzburgresearch.applications.trainreservation.datamodel.Seat;
import at.salzburgresearch.applications.trainreservation.db.DBException;
import at.salzburgresearch.applications.trainreservation.db.IDBAccess;
import at.salzburgresearch.applications.trainreservation.utils.Debug;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class SelectSeatsAction
extends Action {
    public ActionForward perform(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Locale locale = this.getLocale(httpServletRequest);
        MessageResources messageResources = this.getResources();
        HttpSession httpSession = httpServletRequest.getSession();
        ActionErrors actionErrors = new ActionErrors();
        String string = null;
        if (!httpServletRequest.isUserInRole("trainreservation_user") || httpSession.isNew()) {
            return actionMapping.findForward("Start");
        }
        String string2 = ((SelectSeatsForm)actionForm).getAction();
        String string3 = ((SelectSeatsForm)actionForm).getCoachNum();
        String string4 = (String)httpSession.getAttribute("TRAINNUM");
        String string5 = (String)httpSession.getAttribute("TRAVELDATE");
        if (string2 != null && string2.equals(messageResources.getMessage(httpServletRequest.getLocale(), "SelectSeatsView.next"))) {
            Seat seat;
            Debug.print((String)this.getClass().getName(), (String)("Action was " + messageResources.getMessage(httpServletRequest.getLocale(), "SelectSeatsView.next")));
            ArrayList arrayList = ((SelectSeatsForm)actionForm).getCheckedSeats();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                seat = (Seat)iterator.next();
                Debug.print((String)this.getClass().getName(), (String)("Seat " + seat.getSeatNum() + " was checked !"));
            }
            if (arrayList.size() != 0) {
                seat = new Reservation();
                seat.setTrainNum(string4);
                seat.setCoachNum(string3);
                seat.setUserName(httpServletRequest.getUserPrincipal().getName());
                seat.setSeats(arrayList);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                Date date = null;
                try {
                    date = simpleDateFormat.parse(string5);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                seat.setTravelDate(date);
                IDBAccess iDBAccess = null;
                try {
                    iDBAccess = (IDBAccess)Class.forName("at.salzburgresearch.applications.trainreservation.db.InMemoryDB").newInstance();
                    iDBAccess.saveReservation((Reservation)seat);
                    httpServletRequest.setAttribute("RESERVATION", (Object)seat);
                    httpServletRequest.setAttribute("USER", (Object)httpServletRequest.getUserPrincipal().getName());
                    httpSession.invalidate();
                    string = "reservation";
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (DBException dBException) {
                    Debug.print((String)this.getClass().getName(), (String)"Seats not available Exception");
                    actionErrors.add("seatsnotavailable_error", new ActionError(dBException.getErrorKey()));
                    Coach coach = (Coach)httpSession.getAttribute("SELECTED_COACH");
                    coach.setReservedSeats(iDBAccess.getReservedSeatNums(string4, string3, string5));
                    ((SelectSeatsForm)actionForm).reset(actionMapping, httpServletRequest);
                }
            } else {
                actionErrors.add("noseats_error", new ActionError("SelectSeatsView.errors.seats"));
            }
        } else {
            Collection collection = (Collection)httpSession.getAttribute("COACHES");
            Debug.print((String)this.getClass().getName(), (String)("Change coach to " + string3));
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Coach coach = (Coach)iterator.next();
                    if (!string3.equals(coach.getCoachNum())) continue;
                    Debug.print((String)this.getClass().getName(), (String)("Coach" + coach.getCoachNum() + " found"));
                    httpSession.setAttribute("SELECTED_COACH", (Object)coach);
                    try {
                        coach.setReservedSeats(((IDBAccess)Class.forName("at.salzburgresearch.applications.trainreservation.db.InMemoryDB").newInstance()).getReservedSeatNums(string4, string3, string5));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                        // empty catch block
                    }
                    ((SelectSeatsForm)actionForm).setDBData(httpServletRequest);
                }
            } else {
                actionErrors.add("nocoaches_error", new ActionError("SelectSeatsView.errors.coach"));
            }
            string = "change_coach";
        }
        if (!actionErrors.empty()) {
            this.saveErrors(httpServletRequest, actionErrors);
            return new ActionForward(actionMapping.getInput());
        }
        if (actionMapping.getAttribute() != null && "request".equals(actionMapping.getScope())) {
            httpServletRequest.removeAttribute(actionMapping.getAttribute());
        }
        return actionMapping.findForward(string);
    }
}

