/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.applications.trainreservation.db;

import at.salzburgresearch.applications.trainreservation.datamodel.Coach;
import at.salzburgresearch.applications.trainreservation.datamodel.Reservation;
import at.salzburgresearch.applications.trainreservation.datamodel.Seat;
import at.salzburgresearch.applications.trainreservation.datamodel.Timetable;
import at.salzburgresearch.applications.trainreservation.datamodel.Train;
import at.salzburgresearch.applications.trainreservation.db.DBException;
import at.salzburgresearch.applications.trainreservation.db.IDBAccess;
import at.salzburgresearch.applications.trainreservation.utils.Debug;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class InMemoryDB
implements IDBAccess {
    private static Timetable timetable = null;
    private static ArrayList reservations = null;

    public Collection getTrains() {
        return timetable.getTrains();
    }

    public Collection getCoaches(String string) {
        Iterator iterator = timetable.getTrains().iterator();
        while (iterator.hasNext()) {
            Train train = (Train)iterator.next();
            if (!train.getTrainNum().equals(string)) continue;
            return train.getCoaches();
        }
        return new ArrayList();
    }

    public Collection getReservedSeatNums(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = reservations.iterator();
        while (iterator.hasNext()) {
            Reservation reservation = (Reservation)iterator.next();
            String string4 = new SimpleDateFormat("dd.MM.yyyy").format(reservation.getTravelDate());
            if (!string.equals(reservation.getTrainNum()) || !string2.equals(reservation.getCoachNum()) || !string3.equals(string4)) continue;
            Iterator iterator2 = reservation.getSeats().iterator();
            while (iterator2.hasNext()) {
                Seat seat = (Seat)iterator2.next();
                arrayList.add(seat.getSeatNum());
                Debug.print((String)this.getClass().getName(), (String)("Found reserved seat: " + seat.getSeatNum()));
            }
        }
        return arrayList;
    }

    public synchronized void saveReservation(Reservation reservation) throws DBException {
        Iterator iterator = reservations.iterator();
        while (iterator.hasNext()) {
            Reservation reservation2 = (Reservation)iterator.next();
            String string = new SimpleDateFormat("dd.MM.yyyy").format(reservation2.getTravelDate());
            String string2 = new SimpleDateFormat("dd.MM.yyyy").format(reservation.getTravelDate());
            if (!reservation2.getTrainNum().equals(reservation.getTrainNum()) || !reservation2.getCoachNum().equals(reservation.getCoachNum()) || !string.equals(string2)) continue;
            Iterator iterator2 = reservation2.getSeats().iterator();
            while (iterator2.hasNext()) {
                Seat seat = (Seat)iterator2.next();
                Iterator iterator3 = reservation.getSeats().iterator();
                while (iterator3.hasNext()) {
                    Seat seat2 = (Seat)iterator3.next();
                    if (!seat2.getSeatNum().equals(seat.getSeatNum())) continue;
                    throw new DBException("SelectSeatsView.errors.seatsnotavailable");
                }
            }
        }
        reservations.add(reservation);
        Debug.print((String)this.getClass().getName(), (String)"Reservation complete");
    }

    static {
        timetable = new Timetable();
        ArrayList<Train> arrayList = new ArrayList<Train>();
        timetable.setTrains(arrayList);
        ArrayList<Coach> arrayList2 = new ArrayList<Coach>();
        ArrayList<Seat> arrayList3 = new ArrayList<Seat>();
        Train train = new Train("Tauernexpress");
        train.setCoaches(arrayList2);
        Coach coach = new Coach("15", train);
        int n = 1;
        while (n <= 44) {
            arrayList3.add(new Seat(new Integer(n).toString(), coach, false));
            ++n;
        }
        coach.setSeats(arrayList3);
        arrayList2.add(coach);
        coach = new Coach("65", train);
        arrayList3 = new ArrayList();
        int n2 = 1;
        while (n2 <= 20) {
            arrayList3.add(new Seat(new Integer(n2).toString(), coach, false));
            ++n2;
        }
        coach.setSeats(arrayList3);
        arrayList2.add(coach);
        arrayList.add(train);
        train = new Train("Alpenflitzer");
        arrayList2 = new ArrayList();
        train.setCoaches(arrayList2);
        coach = new Coach("12", train);
        arrayList3 = new ArrayList();
        int n3 = 1;
        while (n3 <= 50) {
            arrayList3.add(new Seat(new Integer(n3).toString(), coach, false));
            ++n3;
        }
        coach.setSeats(arrayList3);
        arrayList2.add(coach);
        coach = new Coach("23", train);
        arrayList3 = new ArrayList();
        int n4 = 1;
        while (n4 <= 25) {
            arrayList3.add(new Seat(new Integer(n4).toString(), coach, false));
            ++n4;
        }
        coach.setSeats(arrayList3);
        arrayList2.add(coach);
        coach = new Coach("33", train);
        arrayList3 = new ArrayList();
        int n5 = 1;
        while (n5 <= 33) {
            arrayList3.add(new Seat(new Integer(n5).toString(), coach, false));
            ++n5;
        }
        coach.setSeats(arrayList3);
        arrayList2.add(coach);
        arrayList.add(train);
        train = new Train("Almenbummler");
        arrayList2 = new ArrayList();
        train.setCoaches(arrayList2);
        arrayList.add(train);
        reservations = new ArrayList();
    }
}

