<%@ page  language="java"
          import="at.salzburgresearch.applications.trainreservation.datamodel.*"
          errorPage="error.jsp"%>

<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<html:html locale="true">

<head>
<title><bean:message key="SelectSeatsView.title"/></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="expires" content="0">

<html:base/>
</head>

<body bgcolor="#FFFFFF">

<p>
  <font face="Verdana, Arial, Helvetica, sans-serif" color="#CC0000">
    <bean:message key="message.header"/>
  </font>
</p>
<p>
  <bean:message key="SelectSeatsView.header1"/>
</p>

<hr>
<font color="#CC0000">
  <html:errors property="nocoaches_error"/>
  <html:errors property="noseats_error"/>
  <html:errors property="seatsnotavailable_error"/>
</font>
<p>
  <!-- show selected data from the last view -->
  <bean:message key="SelectSeatsView.TrainNumber"/>
  <bean:write name="TRAINNUM" scope="session"/>
  <bean:message key="SelectSeatsView.BeforeDate"/>
  <bean:write name="TRAVELDATE" scope="session"/>:
</p>

<!-- struts html-tag -->
<html:form method="post" action="selectseats.do">
  <table width="25%" border=0 cellpadding=2 cellspacing=1>
    <tr><td>
      <bean:define  id="COACHNUMS"
                    name="COACHES"
                    scope="session"
                    toScope="page"/>

      <bean:message key="SelectSeatsView.CoachNumber"/>

      <!-- select box for coaches -->
      <html:select  property="coachNum"
                    onchange="submit()">
        <html:options collection="COACHNUMS"
                      property="coachNum"/>
      </html:select>
    </td></tr>
  </table>

  <table width="25%" border=0 cellpadding=2 cellspacing=1>
    <tr bgcolor="#CCCCCC">
      <th align="LEFT" colspan="2">
        <font color="#000000"><b>
          <bean:message key="SelectSeatsView.Seats"/>
        </b> </font>
      </th>
    </tr>

    <!-- iterate over available seats -->
    <logic:iterate  id="seats"
                    indexId="seatIndex"
                    name="SelectSeatsForm"
                    property="seats"
                    type="Seat">

      <!-- define attribute compIndex to compare with seatIndex for breaking the rows -->
      <% pageContext.setAttribute("compIndex",
        new Integer (((Integer)pageContext.getAttribute("seatIndex")).intValue() % 10)); %>

      <!-- start new row if 10 seats are in one row -->
      <logic:equal  name="compIndex"
                    value="0">
        <tr bgcolor="#E0E0E0">
      </logic:equal>

      <td valign="MIDDLE" NOWRAP>
        <bean:write name="seats"
                    property="seatNum"/>
        <!-- insert checkbox with property isChecked -->
        <html:checkbox  name="seats"
                        property="isChecked"
                        indexed="true"
                        disabled="<%=seats.getIsReserved()%>"/>
      </td>

      <!-- end row -->
      <logic:equal  name="compIndex"
                    value="9">
        </tr>
      </logic:equal>

    </logic:iterate>
  </table>

  <p>
    <!-- show description for reservation -->
    <bean:message key="SelectSeatsView.description"/>
  </p>

  <!-- Navigation -->
  <p align="left">
    <!-- insert submit-button, property action -->
    <html:submit property="action">
      <bean:message key="SelectSeatsView.next"/>
    </html:submit>
  </p>
  <hr>
  <p>
  <!-- back link -->
  <html:link forward="SelectTrain">
    <bean:message key="SelectSeatsView.back"/>
  </html:link>
  </p>
</html:form>

</body>

</html:html>

