/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.client.remote;

import com.sun.xml.messaging.jaxm.client.remote.MessageUtil;
import com.sun.xml.messaging.jaxm.ebxml.EbXMLMessageFactoryImpl;
import com.sun.xml.messaging.jaxm.soaprp.SOAPRPMessageFactoryImpl;
import com.sun.xml.messaging.util.StringManager;
import javax.xml.messaging.JAXMException;
import javax.xml.messaging.ProviderConnection;
import javax.xml.messaging.ProviderMetaData;
import javax.xml.messaging.URLEndpoint;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProviderConnectionImpl
implements ProviderConnection {
    private ProviderMetaData metaData;
    private MessageFactory messageFactory = null;
    private static Log logger = LogFactory.getFactory().getInstance("com.sun.xml.messaging.jaxm.client.remote");
    private boolean initialized = false;
    private boolean closed = false;
    private SOAPConnection providerConnection;
    private String uri;
    private URLEndpoint url;
    private String profile;
    String endpoint;
    String callBackURL;
    private StringManager sm = StringManager.getManager((String)"com.sun.xml.messaging.jaxm.client.remote");

    public ProviderConnectionImpl(String uri, String url, String endpoint, String callBackURL) {
        this.uri = uri;
        this.url = new URLEndpoint(url);
        this.endpoint = endpoint;
        this.callBackURL = callBackURL;
    }

    private void initialize() throws JAXMException {
        try {
            SOAPConnectionFactory factory = SOAPConnectionFactory.newInstance();
            this.providerConnection = factory.createConnection();
            this.messageFactory = new EbXMLMessageFactoryImpl();
            SOAPMessage initMsg = MessageUtil.createInitMessage(this.messageFactory, this.uri, this.endpoint, this.callBackURL);
            SOAPMessage initReplyMsg = this.providerConnection.call(initMsg, (Object)this.url);
            this.metaData = MessageUtil.createMetaData(initReplyMsg);
            this.initialized = true;
        }
        catch (SOAPException ex) {
            ex.printStackTrace();
            logger.error((Object)this.sm.getString("provider.connection.initialization.failure"), (Throwable)ex);
            throw new JAXMException("ProviderConnection initialization failed", (Throwable)ex);
        }
    }

    public ProviderMetaData getMetaData() throws JAXMException {
        if (this.closed) {
            throw new JAXMException("Connection already closed");
        }
        if (!this.initialized) {
            this.initialize();
        }
        return this.metaData;
    }

    public void close() throws JAXMException {
        if (this.closed) {
            throw new JAXMException("Connection already closed");
        }
        if (this.initialized) {
            try {
                SOAPMessage closeMsg = MessageUtil.createCloseMessage(this.messageFactory, this.uri, this.endpoint);
                SOAPMessage closeReplyMsg = this.providerConnection.call(closeMsg, (Object)this.url);
                this.providerConnection = null;
                this.metaData = null;
                this.messageFactory = null;
            }
            catch (SOAPException ex) {
                ex.printStackTrace();
                logger.error((Object)this.sm.getString("provider.connection.close.failure"), (Throwable)ex);
                throw new JAXMException("ProviderConnection close failed", (Throwable)ex);
            }
        }
        this.closed = true;
    }

    public MessageFactory createMessageFactory(String profile) throws JAXMException {
        this.profile = profile;
        if (this.closed) {
            throw new JAXMException("Connection already closed");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (profile.equals("ebxml")) {
            return new EbXMLMessageFactoryImpl();
        }
        if (profile.equals("soaprp")) {
            return new SOAPRPMessageFactoryImpl();
        }
        throw new JAXMException("Unsupported profile " + profile);
    }

    public void send(SOAPMessage message) throws JAXMException {
        if (this.closed) {
            throw new JAXMException("Connection already closed");
        }
        if (!this.initialized) {
            this.initialize();
        }
        try {
            SOAPPart sp = message.getSOAPPart();
            SOAPEnvelope env = sp.getEnvelope();
            SOAPHeader hdr = env.getHeader();
            SOAPHeaderElement hdrElement = hdr.addHeaderElement(env.createName("Message", "jaxm", "http://java.sun.com/xml/jaxm"));
            hdrElement.setActor(this.uri);
            hdrElement.setMustUnderstand(true);
            SOAPElement elem = hdrElement.addChildElement("Method");
            elem.addTextNode("SendMessage");
            elem = hdrElement.addChildElement("Profile");
            elem.addTextNode(this.profile);
            message.saveChanges();
            SOAPMessage sendReplyMesg = this.providerConnection.call(message, (Object)this.url);
        }
        catch (SOAPException ex) {
            ex.printStackTrace();
            logger.error((Object)this.sm.getString("provider.message.send.failed"), (Throwable)ex);
            throw new JAXMException("Unable to send message", (Throwable)ex);
        }
    }
}

