/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.config.client;

import com.sun.xml.messaging.jaxm.client.remote.ProviderConnectionFactoryImpl;
import com.sun.xml.messaging.jaxm.util.XmlUtil;
import com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnection;
import com.sun.xml.messaging.util.StringManager;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;

public class Config {
    public static final Log logger = LogFactory.getFactory().getInstance("com.sun.xml.messaging.jaxm.config.client");
    String endpoint;
    String callBackURL;
    String providerURI;
    String providerURL;
    private StringManager sm = StringManager.getManager((String)"com.sun.xml.messaging.jaxm.config.client");

    public Config(InputStream is) {
        try {
            if (is == null) {
                logger.error((Object)this.sm.getString("jaxm.config.client.is.error"));
                return;
            }
            Document doc = XmlUtil.parseConfig(is);
            if (doc == null) {
                logger.error((Object)this.sm.getString("jaxm.config.client.parse.error"));
                return;
            }
            Element root = doc.getRootElement();
            this.endpoint = root.elementTextTrim("Endpoint");
            this.callBackURL = root.elementTextTrim("CallbackURL");
            this.providerURI = root.element("Provider").elementTextTrim("URI");
            this.providerURL = root.element("Provider").elementTextTrim("URL");
            if (root.element("Proxy") != null) {
                HttpSOAPConnection.defaultProxyHost = root.element("Proxy").elementTextTrim("Host");
                HttpSOAPConnection.defaultProxyPort = Integer.parseInt(root.element("Proxy").elementTextTrim("Port"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)this.sm.getString("jaxm.config.client.error"), (Throwable)ex);
        }
    }

    public void configure(ProviderConnectionFactoryImpl pcf) {
        pcf.setProviderData(this.providerURI, this.providerURL);
        pcf.setClientData(this.endpoint, this.callBackURL);
    }
}

