/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.jaxm.util;

import java.util.Hashtable;

public class Logger {
    private static final Logger defaultLog = new Logger("JAXM default logger");
    private static final Hashtable loggers = new Hashtable();
    private String name;

    Logger(String name) {
        this.name = name;
    }

    public static Logger getDefaultLogger() {
        return defaultLog;
    }

    public static Logger getLogger(String name) {
        Logger logger = (Logger)loggers.get(name);
        if (logger == null) {
            logger = new Logger(name);
            loggers.put(name, logger);
        }
        return logger;
    }

    public void log(String message) {
        System.err.println(this.name + " " + message);
    }

    public void logInfo(String message) {
        this.log(message);
    }

    public void logError(String message) {
        this.log(" ERROR: " + message);
    }

    public void logError(String message, Throwable t) {
        this.logError(message);
        System.err.print("\t Exception is: ");
        t.printStackTrace(System.err);
    }
}

