/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.http.handler;

import com.sun.xml.rpc.client.http.handler.AuthenticationInfo;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Arrays;
import sun.misc.BASE64Encoder;

class BasicAuthentication
extends AuthenticationInfo {
    String auth;

    public BasicAuthentication(boolean isProxy, String host, int port, String realm, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', host, port, realm);
        String plain = pw.getUserName() + ":";
        byte[] nameBytes = plain.getBytes();
        char[] passwd = pw.getPassword();
        byte[] passwdBytes = new byte[passwd.length];
        int i = 0;
        while (i < passwd.length) {
            passwdBytes[i] = (byte)passwd[i];
            ++i;
        }
        byte[] concat = new byte[nameBytes.length + passwdBytes.length];
        System.arraycopy(nameBytes, 0, concat, 0, nameBytes.length);
        System.arraycopy(passwdBytes, 0, concat, nameBytes.length, passwdBytes.length);
        this.auth = "Basic " + new BASE64Encoder().encode(concat);
        Arrays.fill(passwd, ' ');
        Arrays.fill(passwdBytes, (byte)0);
        Arrays.fill(concat, (byte)0);
    }

    public BasicAuthentication(boolean isProxy, String host, int port, String realm, String auth) {
        super(isProxy ? (char)'p' : 's', host, port, realm);
        this.auth = "Basic " + auth;
    }

    public BasicAuthentication(boolean isProxy, URL url, String realm, PasswordAuthentication pw) {
        super(isProxy ? (char)'p' : 's', url, realm);
        String plain = pw.getUserName() + ":";
        byte[] nameBytes = plain.getBytes();
        char[] passwd = pw.getPassword();
        byte[] passwdBytes = new byte[passwd.length];
        int i = 0;
        while (i < passwd.length) {
            passwdBytes[i] = (byte)passwd[i];
            ++i;
        }
        byte[] concat = new byte[nameBytes.length + passwdBytes.length];
        System.arraycopy(nameBytes, 0, concat, 0, nameBytes.length);
        System.arraycopy(passwdBytes, 0, concat, nameBytes.length, passwdBytes.length);
        this.auth = "Basic " + new BASE64Encoder().encode(concat);
        Arrays.fill(passwd, ' ');
        Arrays.fill(passwdBytes, (byte)0);
        Arrays.fill(concat, (byte)0);
    }

    public BasicAuthentication(boolean isProxy, URL url, String realm, String auth) {
        super(isProxy ? (char)'p' : 's', url, realm);
        this.auth = "Basic " + auth;
    }

    boolean supportsPreemptiveAuthorization() {
        return true;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    String getHeaderValue() {
        return this.auth;
    }
}

