/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.PolymorphicArraySerializer;
import com.sun.xml.rpc.encoding.ReferenceableSerializerImpl;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerConstants;
import com.sun.xml.rpc.encoding.TypeMappingException;
import com.sun.xml.rpc.encoding.ValueObjectSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralFragmentSerializer;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;

public class DynamicInternalTypeMappingRegistry
implements InternalTypeMappingRegistry,
SerializerConstants {
    protected static final QName ELEMENT_NAME = new QName("element");
    protected InternalTypeMappingRegistry registry = null;
    static /* synthetic */ Class class$java$rmi$Remote;

    public DynamicInternalTypeMappingRegistry(InternalTypeMappingRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("registry must not be null");
        }
        this.registry = registry;
    }

    public Serializer getSerializer(String encoding, Class javaType, QName xmlType) throws Exception {
        try {
            return this.registry.getSerializer(encoding, javaType, xmlType);
        }
        catch (TypeMappingException ex) {
            try {
                if (encoding.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    if (DynamicInternalTypeMappingRegistry.isArray(javaType, xmlType)) {
                        return this.createArraySerializer(javaType, xmlType);
                    }
                    if (DynamicInternalTypeMappingRegistry.isValueType(javaType)) {
                        return this.createValueSerializer(javaType, xmlType);
                    }
                } else if (encoding.equals("")) {
                    return this.createLiteralSerializer(xmlType);
                }
                throw ex;
            }
            catch (JAXRPCExceptionBase e) {
                throw new SerializationException(e);
            }
            catch (Exception e) {
                throw new SerializationException(new LocalizableExceptionAdapter(e));
            }
        }
    }

    public Deserializer getDeserializer(String encoding, Class javaType, QName xmlType) throws Exception {
        try {
            return this.registry.getDeserializer(encoding, javaType, xmlType);
        }
        catch (TypeMappingException ex) {
            try {
                if (encoding.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                    if (DynamicInternalTypeMappingRegistry.isArray(javaType, xmlType)) {
                        return this.createArraySerializer(javaType, xmlType);
                    }
                    return this.createValueSerializer(javaType, xmlType);
                }
                if (encoding.equals("")) {
                    return this.createLiteralSerializer(xmlType);
                }
                throw ex;
            }
            catch (JAXRPCExceptionBase e) {
                throw new SerializationException(e);
            }
            catch (Exception e) {
                throw new SerializationException(new LocalizableExceptionAdapter(e));
            }
        }
    }

    private ReferenceableSerializerImpl createArraySerializer(Class javaType, QName xmlType) throws Exception {
        if (javaType == null || xmlType == null) {
            return null;
        }
        ReferenceableSerializerImpl serializer = new ReferenceableSerializerImpl(false, new PolymorphicArraySerializer(xmlType, false, true, "http://schemas.xmlsoap.org/soap/encoding/", ELEMENT_NAME));
        serializer.initialize(this.registry);
        return serializer;
    }

    private ReferenceableSerializerImpl createValueSerializer(Class javaType, QName xmlType) throws Exception {
        if (javaType == null || xmlType == null) {
            return null;
        }
        ReferenceableSerializerImpl serializer = new ReferenceableSerializerImpl(false, new ValueObjectSerializer(xmlType, false, true, "http://schemas.xmlsoap.org/soap/encoding/", javaType));
        serializer.initialize(this.registry);
        return serializer;
    }

    private ReferenceableSerializerImpl createLiteralSerializer(QName xmlType) throws Exception {
        if (xmlType == null) {
            return null;
        }
        ReferenceableSerializerImpl serializer = new ReferenceableSerializerImpl(false, new LiteralFragmentSerializer(xmlType, true, ""));
        serializer.initialize(this.registry);
        return serializer;
    }

    public Serializer getSerializer(String encoding, Class javaType) throws Exception {
        return this.registry.getSerializer(encoding, javaType);
    }

    public Serializer getSerializer(String encoding, QName xmlType) throws Exception {
        return this.registry.getSerializer(encoding, xmlType);
    }

    public Deserializer getDeserializer(String encoding, QName xmlType) throws Exception {
        return this.registry.getDeserializer(encoding, xmlType);
    }

    public Class getJavaType(String encoding, QName xmlType) throws Exception {
        return this.registry.getJavaType(encoding, xmlType);
    }

    public QName getXmlType(String encoding, Class javaType) throws Exception {
        return this.registry.getXmlType(encoding, javaType);
    }

    public static boolean isArray(Class javaType, QName xmlType) {
        return javaType != null && javaType.isArray() && SOAPConstants.QNAME_ENCODING_ARRAY.equals(xmlType);
    }

    public static boolean isValueType(Class javaType) throws Exception {
        if (javaType == null || (class$java$rmi$Remote == null ? (class$java$rmi$Remote = DynamicInternalTypeMappingRegistry.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(javaType)) {
            return false;
        }
        boolean hasPublicConstructor = false;
        Constructor<?>[] constructors = javaType.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 0) {
                hasPublicConstructor = true;
                break;
            }
            ++i;
        }
        if (!hasPublicConstructor) {
            return false;
        }
        boolean hasPropertiesOrPublicFields = false;
        if (Introspector.getBeanInfo(javaType).getPropertyDescriptors().length == 0) {
            Field[] fields = javaType.getFields();
            int i2 = 0;
            while (i2 < fields.length) {
                Field currentField = fields[i2];
                int fieldModifiers = currentField.getModifiers();
                if (Modifier.isPublic(fieldModifiers) && !Modifier.isTransient(fieldModifiers) && !Modifier.isFinal(fieldModifiers)) {
                    hasPropertiesOrPublicFields = true;
                    break;
                }
                ++i2;
            }
        } else {
            hasPropertiesOrPublicFields = true;
        }
        return hasPropertiesOrPublicFields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

