/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.soap;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import javax.xml.namespace.QName;

public class SOAPRequestSerializer
extends ObjectSerializerBase
implements Initializable {
    protected QName[] parameterNames;
    protected QName[] parameterTypes;
    protected Class[] parameterClasses;
    protected JAXRPCSerializer[] serializers;
    protected JAXRPCDeserializer[] deserializers;
    protected InternalTypeMappingRegistry typeRegistry = null;

    public SOAPRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses) {
        super(type, encodeType, isNullable, encodingStyle);
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes;
        this.parameterClasses = parameterClasses;
    }

    public SOAPRequestSerializer(QName type, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses) {
        this(type, false, true, "http://schemas.xmlsoap.org/soap/encoding/", parameterNames, parameterTypes, parameterClasses);
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        this.serializers = new JAXRPCSerializer[this.parameterTypes.length];
        this.deserializers = new JAXRPCDeserializer[this.parameterTypes.length];
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (this.parameterClasses[i] != null) {
                this.serializers[i] = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, this.parameterClasses[i], this.parameterTypes[i]);
                this.deserializers[i] = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, this.parameterClasses[i], this.parameterTypes[i]);
            } else {
                this.serializers[i] = null;
                this.deserializers[i] = null;
            }
            ++i;
        }
        this.typeRegistry = registry;
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initalizable.not.initialized");
        }
        Object[] parameters = (Object[])instance;
        this.checkParameterListLength(parameters);
        int i = 0;
        while (i < parameters.length) {
            Object parameter = parameters[i];
            this.getParameterSerializer(i, parameter).serialize(parameter, this.getParameterName(i), null, writer, context);
            ++i;
        }
    }

    protected Object doDeserialize(SOAPDeserializationState existingState, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initalizable.not.initialized");
        }
        Object[] instance = new Object[this.parameterTypes.length];
        ParameterArrayBuilder builder = null;
        boolean isComplete = true;
        SOAPDeserializationState state = existingState;
        int i = 0;
        while (i < this.parameterTypes.length) {
            reader.nextElementContent();
            QName parameterName = this.getParameterName(i);
            if (reader.getName().equals(parameterName)) {
                Object parameter = this.getParameterDeserializer(i, reader).deserialize(parameterName, reader, context);
                if (parameter instanceof SOAPDeserializationState) {
                    if (builder == null) {
                        builder = new ParameterArrayBuilder(instance);
                    }
                    state = ObjectSerializerBase.registerWithMemberState(instance, state, parameter, i, builder);
                    isComplete = false;
                } else {
                    instance[i] = parameter;
                }
            }
            ++i;
        }
        reader.nextElementContent();
        XMLReaderUtil.verifyReaderState(reader, 2);
        return isComplete ? instance : state;
    }

    protected JAXRPCSerializer getParameterSerializer(int index, Object parameter) throws Exception {
        JAXRPCSerializer serializer = this.getSerializer(index);
        if (serializer == null) {
            Class<?> parameterClass = null;
            if (parameter != null) {
                parameterClass = parameter.getClass();
            }
            serializer = (JAXRPCSerializer)this.typeRegistry.getSerializer(this.encodingStyle, parameterClass, this.getParameterType(index));
        }
        return serializer;
    }

    protected JAXRPCDeserializer getParameterDeserializer(int index, XMLReader reader) throws Exception {
        JAXRPCDeserializer deserializer = this.getDeserializer(index);
        if (deserializer == null) {
            QName parameterXmlType = XMLReaderUtil.getQNameValue(reader, XSDConstants.QNAME_XSI_TYPE);
            deserializer = (JAXRPCDeserializer)this.typeRegistry.getDeserializer(this.encodingStyle, this.getParameterClass(index), parameterXmlType);
        }
        return deserializer;
    }

    private Class getParameterClass(int index) {
        if (index < this.parameterClasses.length) {
            return this.parameterClasses[index];
        }
        return null;
    }

    private QName getParameterType(int index) {
        if (index < this.parameterTypes.length) {
            return this.parameterTypes[index];
        }
        return null;
    }

    private QName getParameterName(int index) {
        if (index < this.parameterNames.length) {
            return this.parameterNames[index];
        }
        return null;
    }

    private JAXRPCDeserializer getDeserializer(int index) {
        if (index < this.deserializers.length) {
            return this.deserializers[index];
        }
        return null;
    }

    private JAXRPCSerializer getSerializer(int index) {
        if (index < this.serializers.length) {
            return this.serializers[index];
        }
        return null;
    }

    private void checkParameterListLength(Object[] parameters) {
        if (this.serializers.length > 0 && parameters.length != this.serializers.length) {
            String expectedParameters = "\n";
            String actualParameters = "\n";
            int i = 0;
            while (i < this.parameterNames.length) {
                QName name = this.parameterNames[i];
                QName xmlType = this.parameterTypes[i];
                expectedParameters = expectedParameters + name + ":" + this.type;
                if (i + 1 != this.parameterNames.length) {
                    expectedParameters = expectedParameters + "\n";
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < parameters.length) {
                Object parameter = parameters[i2];
                String javaType = parameter == null ? "null" : parameter.getClass().getName();
                actualParameters = actualParameters + javaType;
                if (i2 + 1 != parameters.length) {
                    actualParameters = actualParameters + "\n";
                }
                ++i2;
            }
            throw new SerializationException("request.parameter.count.incorrect", new Object[]{new Integer(this.serializers.length), new Integer(parameters.length), expectedParameters, actualParameters});
        }
    }

    protected static class ParameterArrayBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;

        ParameterArrayBuilder(Object[] instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                this.instance[index] = memberValue;
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
            instance = instance;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

