/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CustomExceptionGenerator
extends GeneratorBase {
    private Set faults;

    public CustomExceptionGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new CustomExceptionGenerator(model, config, properties);
    }

    private CustomExceptionGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.faults = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.faults = null;
    }

    protected void preVisitFault(Fault fault) throws Exception {
        if (this.isRegistered(fault)) {
            return;
        }
        this.registerFault(fault);
        if (fault.getParentFault() != null) {
            this.preVisitFault(fault.getParentFault());
        }
    }

    private boolean isRegistered(Fault fault) {
        return this.faults.contains(fault.getJavaException().getName());
    }

    private void registerFault(Fault fault) {
        this.faults.add(fault.getJavaException().getName());
        this.generateCustomException(fault);
    }

    private void generateCustomException(Fault fault) {
        if (fault.getJavaException().isPresent()) {
            return;
        }
        this.log("generating CustomException for: " + fault.getJavaException().getName());
        try {
            String className = this.env.getNames().customExceptionClassName(fault);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            JavaException javaStructure = fault.getJavaException();
            this.writeClassDecl(out, className, javaStructure);
            this.writeMembers(out, fault);
            out.pln();
            this.writeClassConstructor(out, className, fault);
            out.pln();
            this.writeGetter(out, fault);
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeClassDecl(IndentingWriter p, String className, JavaStructureType javaStruct) throws IOException {
        JavaStructureType superclass = javaStruct.getSuperclass();
        if (superclass != null) {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" extends ").append(superclass.getRealName()).append(" {").toString());
        } else {
            StringBuffer stringBuffer = new StringBuffer().append("public class ");
            this.env.getNames();
            p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" extends Exception {").toString());
        }
    }

    private void writeMembers(IndentingWriter p, Fault fault) throws IOException {
        Iterator members = fault.getJavaException().getMembers();
        while (members.hasNext()) {
            JavaStructureMember member = (JavaStructureMember)members.next();
            if (member.isInherited()) continue;
            p.pln("private " + member.getType().getRealName() + " " + member.getName() + ";");
        }
        p.pln();
    }

    private void writeClassConstructor(IndentingWriter p, String className, Fault fault) throws IOException {
        int i;
        JavaStructureMember member;
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.p(stringBuffer.append(Names.mangleClass(className)).append("(").toString());
        Iterator members = fault.getJavaException().getMembers();
        int i2 = 0;
        while (members.hasNext()) {
            member = (JavaStructureMember)members.next();
            if (i2 > 0) {
                p.p(", ");
            }
            p.p(member.getType().getRealName() + " " + member.getName());
            ++i2;
        }
        p.plnI(") {");
        if (fault.getParentFault() != null) {
            members = fault.getJavaException().getMembers();
            i = 0;
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                if (!member.isInherited()) continue;
                if (i++ == 0) {
                    p.p("super(");
                } else {
                    p.p(", ");
                }
                p.p(member.getName());
            }
            if (i > 0) {
                p.pln(");");
            }
        }
        members = fault.getJavaException().getMembers();
        i = 0;
        while (members.hasNext()) {
            member = (JavaStructureMember)members.next();
            if (!member.isInherited()) {
                p.pln("this." + member.getName() + " = " + member.getName() + ";");
            }
            ++i;
        }
        p.pOln("}");
    }

    private void writeGetter(IndentingWriter p, Fault fault) throws IOException {
        Iterator members = fault.getJavaException().getMembers();
        int i = 0;
        while (members.hasNext()) {
            JavaStructureMember member;
            if (i > 0) {
                p.pln();
            }
            if ((member = (JavaStructureMember)members.next()).isInherited()) continue;
            p.plnI("public " + member.getType().getRealName() + " " + member.getReadMethod() + "() {");
            p.pln("return " + member.getName() + ";");
            p.pOln("}");
            ++i;
        }
    }
}

