/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class EnumerationEncoderGenerator
extends GeneratorBase {
    private Set types;

    public EnumerationEncoderGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new EnumerationEncoderGenerator(model, config, properties);
    }

    private EnumerationEncoderGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        this.generateEnumerationSerializer(type);
    }

    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPArrayType(type);
    }

    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
        super.visitSOAPStructureType(type);
    }

    private boolean isRegistered(SOAPType type) {
        return this.types.contains(type);
    }

    private void registerType(SOAPType type) {
        this.types.add(type);
    }

    private void generateEnumerationSerializer(SOAPEnumerationType type) {
        this.log("generating Enumeration for: " + this.env.getNames().typeObjectSerializerClassName(type));
        try {
            String className = type.getJavaType().getRealName() + "_Encoder";
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            out.pln();
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className);
            out.pln();
            this.writeMembers(out, type, className);
            out.pln();
            this.writeConstructor(out, className);
            out.pln();
            this.writeGetInstance(out);
            out.pln();
            this.writeObjectToString(out, type);
            out.pln();
            this.writeStringToObject(out, type);
            out.pln();
            this.writeGenericMethods(out, type);
            out.pOln("}");
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (Exception e) {
            GeneratorBase.fail(e);
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        p.pln("import javax.xml.namespace.QName;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" implements SimpleTypeEncoder {").toString());
    }

    private void writeMembers(IndentingWriter p, SOAPEnumerationType type, String className) throws IOException {
        String encoder = SimpleTypeSerializerWriter.getTypeEncoder(type.getBaseType());
        p.pln("private static final SimpleTypeEncoder encoder = " + encoder + ".getInstance();");
        StringBuffer stringBuffer = new StringBuffer().append("private static final ");
        this.env.getNames();
        StringBuffer stringBuffer2 = stringBuffer.append(Names.stripQualifier(className)).append(" instance = new ");
        this.env.getNames();
        p.pln(stringBuffer2.append(Names.stripQualifier(className)).append("();").toString());
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("private ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.stripQualifier(className)).append("() {").toString());
        p.pOln("}");
    }

    private void writeGetInstance(IndentingWriter p) throws IOException {
        p.plnI("public static SimpleTypeEncoder getInstance() {");
        p.pln("return instance;");
        p.pOln("}");
    }

    private void writeObjectToString(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public String objectToString(Object obj, XMLWriter writer) throws Exception {");
        p.pln(baseTypeStr + " value = ((" + className + ")obj).getValue();");
        String valueExp = "value";
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            valueExp = SimpleToBoxedUtil.getBoxedExpressionOfType(valueExp, baseTypeStr);
        }
        p.pln("return encoder.objectToString(" + valueExp + ", writer);");
        p.pOln("}");
    }

    private void writeStringToObject(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        JavaEnumerationType javaEnum = (JavaEnumerationType)type.getJavaType();
        String baseTypeStr = javaEnum.getBaseType().getRealName();
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public Object stringToObject(String str, XMLReader reader) throws Exception {");
        String objectExp = "(" + SimpleToBoxedUtil.getBoxedClassName(baseTypeStr) + ")encoder.stringToObject(str, reader)";
        if (SimpleToBoxedUtil.isPrimitive(baseTypeStr)) {
            objectExp = SimpleToBoxedUtil.getUnboxedExpressionOfType(objectExp, baseTypeStr);
        }
        p.pln("return " + className + ".fromValue(" + objectExp + ");");
        p.pOln("}");
    }

    private void writeGenericMethods(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        p.pln("public void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {");
        p.pln("}");
    }

    private void writeEquals(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        this.env.getNames();
        String className = Names.stripQualifier(type.getJavaType().getRealName());
        p.plnI("public boolean equals(Object obj) {");
        p.plnI("if (!obj instanceof " + className + ") {");
        p.pln("return false;");
        p.pOln("}");
        p.pln("((" + className + ")obj).value.equals(value);");
        p.pOln("}");
    }

    private void writeHashCode(IndentingWriter p, SOAPEnumerationType type) throws IOException {
        p.plnI("public int hashCode() {");
        p.pln("return value.hashCode();");
        p.pOln("}");
    }
}

