/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class SOAPObjectBuilderGenerator
extends GeneratorBase {
    private ArrayList soapBuilders;

    public SOAPObjectBuilderGenerator() {
        this.soapBuilders = null;
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new SOAPObjectBuilderGenerator(model, config, properties);
    }

    private SOAPObjectBuilderGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        this.soapBuilders = new ArrayList();
    }

    protected void postVisitModel(Model model) throws Exception {
        Iterator types = model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (!type.isSOAPType()) continue;
            ((SOAPType)type).accept(this);
        }
    }

    protected void visitFault(Fault fault) throws Exception {
        JavaException exception = fault.getJavaException();
        AbstractType aType = (AbstractType)exception.getOwner();
        if (aType.isSOAPType()) {
            ((SOAPType)aType).accept(this);
        }
        Iterator members = exception.getMembers();
        while (members.hasNext()) {
            SOAPType type = ((SOAPStructureMember)((JavaStructureMember)members.next()).getOwner()).getType();
            type.accept(this);
        }
    }

    protected void preVisitSOAPStructureType(SOAPStructureType structureType) throws Exception {
        if (this.hasObjectBuilder(structureType)) {
            return;
        }
        try {
            this.generateObjectBuilderForType(structureType);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", structureType.getName().getLocalPart());
        }
    }

    private void generateObjectBuilderForType(SOAPStructureType type) throws IOException {
        this.addObjectBuilder(type);
        if (SOAPObjectBuilderGenerator.needBuilder(type)) {
            this.writeObjectBuilderForType(type);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean needBuilder(SOAPStructureType type) {
        members = type.getMembers();
        needBuilder = false;
        if (!((JavaStructureType)type.getJavaType()).isAbstract()) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            member = (SOAPStructureMember)members.next();
            javaMember = member.getJavaStructureMember();
            if (!javaMember.isPublic() && javaMember.getConstructorPos() < 0 && javaMember.getWriteMethod() == null) {
                return false;
            }
            if (!member.getType().isReferenceable()) continue;
            needBuilder = true;
lbl11:
            // 3 sources

            ** while (members.hasNext() && !needBuilder)
        }
lbl12:
        // 1 sources

        return needBuilder;
    }

    public static JavaStructureMember[] getConstructorArgs(JavaStructureType type) {
        ArrayList<JavaStructureMember> args = new ArrayList<JavaStructureMember>();
        Iterator members = type.getMembers();
        int i = 0;
        while (members.hasNext()) {
            JavaStructureMember member = (JavaStructureMember)members.next();
            if (member.getConstructorPos() == i) {
                args.add(member);
            }
            ++i;
        }
        JavaStructureMember[] argArray = new JavaStructureMember[args.size()];
        return args.toArray(argArray);
    }

    private void writeObjectBuilderForType(SOAPStructureType type) throws IOException {
        JavaType javaType = type.getJavaType();
        if (javaType == null) {
            GeneratorBase.fail("generator.invalid.model.state.no.javatype", type.getName().getLocalPart());
        }
        String className = this.env.getNames().typeObjectBuilderClassName(type);
        File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            this.writeObjectBuilderCode(out, type);
            out.close();
            this.log("wrote file: " + classFile.getPath());
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", classFile.toString());
        }
    }

    private void writeObjectBuilderCode(IndentingWriter p, SOAPStructureType type) throws IOException {
        this.log("writing object builder for: " + type.getName().getLocalPart());
        String className = this.env.getNames().typeObjectBuilderClassName(type);
        GeneratorBase.writePackage(p, className);
        this.writeImports(p);
        p.pln();
        this.writeObjectClassDecl(p, className);
        this.writeMembers(p, type);
        p.pln();
        this.writeConstructor(p, className, type);
        p.pln();
        this.writeSetMembers(p, type);
        p.pln();
        this.writeMemberGateTypeMethod(p, type);
        p.pln();
        this.writeConstructMethod(p, type);
        p.pln();
        this.writeSetMemberMethod(p, type);
        p.pln();
        this.writeInitializeMethod(p, type);
        p.pln();
        this.writeGetSetInstanceMethods(p, type);
        p.pOln("}");
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import java.lang.IllegalArgumentException;");
    }

    private void writeObjectClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" implements SOAPInstanceBuilder {").toString());
    }

    private void writeMembers(IndentingWriter p, SOAPStructureType type) throws IOException {
        JavaStructureMember javaMember;
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        String unqualifiedClassName = javaStructure.getRealName();
        this.env.getNames();
        unqualifiedClassName = Names.getUnqualifiedClassName(unqualifiedClassName);
        p.pln("private " + unqualifiedClassName + " _instance;");
        Iterator iterator = javaStructure.getMembers();
        while (iterator.hasNext()) {
            javaMember = (JavaStructureMember)iterator.next();
            p.pln("private " + javaMember.getType().getRealName() + " " + this.env.getNames().validJavaName(javaMember.getName()) + ";");
        }
        iterator = javaStructure.getMembers();
        int i = 0;
        while (iterator.hasNext()) {
            javaMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember member = (SOAPStructureMember)javaMember.getOwner();
            p.p("private static final int ");
            p.pln(this.env.getNames().memberName(member.getName().getLocalPart().toUpperCase() + "_INDEX") + " = " + i + ";");
            ++i;
        }
    }

    public static boolean needsConstructor(SOAPStructureType type) {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator members = javaStructure.getMembers();
        boolean writeContent = false;
        int i = 0;
        while (members.hasNext()) {
            JavaStructureMember member = (JavaStructureMember)members.next();
            if (member.getConstructorPos() >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeConstructor(IndentingWriter p, String className, SOAPStructureType type) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.pln(stringBuffer.append(Names.mangleClass(className)).append("() {").toString());
        p.pln("}");
        if (!SOAPObjectBuilderGenerator.needsConstructor(type)) {
            return;
        }
        p.pln();
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator members = javaStructure.getMembers();
        if (members.hasNext()) {
            JavaType javaType;
            JavaStructureMember member;
            p.pln();
            StringBuffer stringBuffer2 = new StringBuffer().append("public ");
            this.env.getNames();
            p.p(stringBuffer2.append(Names.mangleClass(className)).append("(").toString());
            int i = 0;
            while (members.hasNext()) {
                if (i != 0) {
                    p.p(", ");
                }
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                p.p(member.getType().getRealName() + " " + this.env.getNames().validJavaName(member.getName()));
                ++i;
            }
            p.plnI(") {");
            members = javaStructure.getMembers();
            int i2 = 0;
            while (members.hasNext()) {
                member = (JavaStructureMember)members.next();
                javaType = member.getType();
                p.pln("this." + this.env.getNames().validJavaName(member.getName()) + " = " + this.env.getNames().validJavaName(member.getName()) + ";");
                ++i2;
            }
            p.pOln("}");
        }
    }

    private void writeSetMembers(IndentingWriter p, SOAPStructureType type) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        int i = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaMember;
            String writeMethod;
            if (i > 0) {
                p.pln();
            }
            if ((writeMethod = (javaMember = (JavaStructureMember)iterator.next()).getWriteMethod()) == null) {
                writeMethod = "set" + StringUtils.capitalize(javaMember.getName());
            }
            p.plnI("public void " + writeMethod + "(" + javaMember.getType().getRealName() + " " + this.env.getNames().validJavaName(javaMember.getName()) + ") {");
            p.pln("this." + this.env.getNames().validJavaName(javaMember.getName()) + " = " + this.env.getNames().validJavaName(javaMember.getName()) + ";");
            p.pOln("}");
            ++i;
        }
    }

    private void writeMemberGateTypeMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("public int memberGateType(int memberIndex) {");
        p.plnI("switch (memberIndex) {");
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        int i = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember member = (SOAPStructureMember)javaMember.getOwner();
            boolean referenceable = member.getType().isReferenceable();
            if (referenceable) {
                p.plnI("case " + this.env.getNames().memberName(member.getName().getLocalPart().toUpperCase() + "_INDEX") + ":");
                if (javaMember.getConstructorPos() < 0) {
                    p.pln("return GATES_INITIALIZATION | REQUIRES_CREATION;");
                } else {
                    p.pln("return GATES_CONSTRUCTION | REQUIRES_INITIALIZATION;");
                }
                p.pO();
            }
            ++i;
        }
        p.plnI("default:");
        p.pln("throw new IllegalArgumentException();");
        p.pO();
        p.pOln("}");
        p.pOln("}");
    }

    private void writeConstructMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        String unqualifiedClassName = javaStructure.getRealName();
        this.env.getNames();
        unqualifiedClassName = Names.getUnqualifiedClassName(unqualifiedClassName);
        JavaStructureMember[] constructorArgs = SOAPObjectBuilderGenerator.getConstructorArgs(javaStructure);
        p.plnI("public void construct() {");
        if (constructorArgs.length > 0) {
            p.p("_instance = new " + unqualifiedClassName + "(");
            int i = 0;
            while (i < constructorArgs.length) {
                if (i > 0) {
                    p.p(", ");
                }
                JavaStructureMember javaMember = constructorArgs[i];
                p.p(this.env.getNames().validJavaName(javaMember.getName()));
                ++i;
            }
            p.pln(");");
        }
        p.pOln("}");
    }

    private void writeSetMemberMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        p.plnI("public void setMember(int index, Object memberValue) {");
        p.plnI("switch(index) {");
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        int i = 0;
        while (iterator.hasNext()) {
            JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
            SOAPStructureMember member = (SOAPStructureMember)javaMember.getOwner();
            boolean referenceable = member.getType().isReferenceable();
            if (referenceable) {
                p.plnI("case " + this.env.getNames().memberName(member.getName().getLocalPart().toUpperCase() + "_INDEX") + ":");
                if (javaMember.isPublic()) {
                    p.p("_instance.");
                    p.pln(this.env.getNames().validJavaName(javaMember.getName()) + " = (" + javaMember.getType().getRealName() + ")memberValue;");
                } else if (javaMember.getConstructorPos() < 0) {
                    p.p("_instance.");
                    p.pln(javaMember.getWriteMethod() + "((" + javaMember.getType().getRealName() + ")memberValue);");
                } else {
                    String writeMethod = javaMember.getWriteMethod();
                    if (writeMethod == null) {
                        writeMethod = "set" + StringUtils.capitalize(javaMember.getName());
                    }
                    p.pln(writeMethod + "((" + javaMember.getType().getRealName() + ")memberValue);");
                }
                p.pln("break;");
                p.pO();
            }
            ++i;
        }
        p.plnI("default:");
        p.pln("throw new IllegalArgumentException();");
        p.pO();
        p.pOln("}");
        p.pOln("}");
    }

    private void writeInitializeMethod(IndentingWriter p, SOAPStructureType type) throws IOException {
        JavaStructureType javaStructure = (JavaStructureType)type.getJavaType();
        Iterator iterator = javaStructure.getMembers();
        boolean writeContent = false;
        p.plnI("public void initialize() {");
        if (writeContent) {
            iterator = javaStructure.getMembers();
            p.plnI("for (int i=0; i<memberSet.length; i++) {");
            p.plnI("if (!memberSet[i]) {");
            p.pln("continue;");
            p.pOln("}");
            p.plnI("switch(i) {");
            int i = 0;
            while (iterator.hasNext()) {
                JavaStructureMember javaMember = (JavaStructureMember)iterator.next();
                SOAPStructureMember soapMember = (SOAPStructureMember)javaMember.getOwner();
                if (soapMember.getType().isReferenceable() && !javaMember.isPublic() && javaMember.getConstructorPos() < 0) {
                    p.plnI("case " + this.env.getNames().memberName(soapMember.getName().getLocalPart().toUpperCase() + "_INDEX") + ":");
                    p.pln("_instance." + javaMember.getWriteMethod() + "(" + this.env.getNames().validJavaName(javaMember.getName()) + ");");
                    p.pln("break;");
                    p.pO();
                }
                ++i;
            }
            p.pOln("}");
            p.pOln("}");
        }
        p.pOln("}");
    }

    private void writeGetSetInstanceMethods(IndentingWriter p, SOAPStructureType type) throws IOException {
        String unqualifiedClassName = type.getJavaType().getRealName();
        this.env.getNames();
        unqualifiedClassName = Names.getUnqualifiedClassName(unqualifiedClassName);
        p.plnI("public void setInstance(Object instance) {");
        p.pln("_instance = (" + unqualifiedClassName + ")instance;");
        p.pOln("}");
        p.pln();
        p.plnI("public Object getInstance() {");
        p.pln("return _instance;");
        p.pOln("}");
    }

    private boolean hasObjectBuilder(SOAPType type) {
        return this.soapBuilders.contains(type);
    }

    private void addObjectBuilder(SOAPType type) throws IOException {
        if (this.soapBuilders.contains(type)) {
            GeneratorBase.fail("Internal error: attempting to add duplicate SOAP builder");
        }
        this.soapBuilders.add(type);
    }
}

