/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.client.BasicService;
import com.sun.xml.rpc.encoding.CombinedSerializer;
import com.sun.xml.rpc.encoding.ValueObjectSerializer;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.CollectionSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.DynamicSerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.generator.writer.SimpleTypeSerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;

public class SerializerRegistryGenerator
extends GeneratorBase {
    private static final String SERIALIZER_FACTORY = "serializerFactory";
    private static final String DESERIALIZER_FACTORY = "deserializerFactory";
    private static final String MAPPING = "mapping";
    private static final String LITERAL_MAPPING = "mapping2";
    private boolean haveCustom = false;
    private Model model;
    private Set visitedTypes;
    static /* synthetic */ Class array$B;

    public SerializerRegistryGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new SerializerRegistryGenerator(model, config, properties);
    }

    private SerializerRegistryGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
        this.model = model;
    }

    protected void preVisitService(Service service) throws Exception {
        this.visitedTypes = new HashSet();
        Iterator types = this.model.getExtraTypes();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (!type.isSOAPType()) continue;
            ((SOAPType)type).accept(this);
        }
    }

    protected void postVisitService(Service service) throws Exception {
        try {
            this.generateSerializerRegistry(service);
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", service.getName().getLocalPart());
        }
        this.visitedTypes = null;
    }

    protected void visitParameter(Parameter param) throws Exception {
        AbstractType type = param.getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        }
    }

    protected void preVisitResponse(Response response) throws Exception {
        Iterator iter = response.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    protected void preVisitRequest(Request request) throws Exception {
        Iterator iter = request.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
    }

    public void visit(Fault fault) throws Exception {
        if (fault.getBlock().getType().isSOAPType()) {
            ((SOAPType)fault.getBlock().getType()).accept(this);
        } else if (fault.getBlock().getType().isLiteralType()) {
            ((LiteralType)fault.getBlock().getType()).accept(this);
        }
    }

    public void visit(SOAPCustomType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        this.haveCustom = true;
    }

    public void visit(SOAPSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(SOAPAnyType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
        this.haveCustom = true;
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(LiteralSimpleType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void visit(LiteralFragmentType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    public void preVisitLiteralAllType(LiteralAllType type) throws Exception {
        if (this.haveVisited(type)) {
            return;
        }
        this.typeVisited(type);
    }

    private boolean haveVisited(AbstractType type) {
        return this.visitedTypes.contains(type);
    }

    private void typeVisited(AbstractType type) {
        this.visitedTypes.add(type);
    }

    private void generateSerializerRegistry(Service service) throws IOException {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().serializerRegistryClassName(intf);
            this.log("creating serializer registry: " + className);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            this.env.addGeneratedFile(classFile);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className);
            this.writeImports(out);
            out.pln();
            this.writeClassDecl(out, className);
            this.writeConstructor(out, className);
            out.pln();
            this.writeGetRegistry(out);
            out.pln();
            this.writeStatics(out);
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.client.BasicService;");
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.simpletype.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.*;");
        p.pln("import com.sun.xml.rpc.encoding.literal.*;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.rpc.*;");
        p.pln("import javax.xml.rpc.encoding.*;");
        p.pln("import javax.xml.namespace.QName;");
    }

    private void writeClassDecl(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public class ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append(" implements SerializerConstants {").toString());
    }

    private void writeStatics(IndentingWriter p) throws IOException, Exception {
        p.plnI("private static void registerSerializer(TypeMapping mapping, Class javaType, QName xmlType,");
        p.pln("Serializer ser) {");
        p.plnI("mapping.register(javaType, xmlType, new SingletonSerializerFactory(ser),");
        p.pln("new SingletonDeserializerFactory((Deserializer)ser));");
        p.pO();
        p.pOln("}");
        p.pln();
    }

    private boolean mappingExistsForType(TypeMapping mapping, AbstractType type) {
        try {
            SerializerFactory factory;
            Serializer ser;
            Class<Object> cls = null;
            String javaName = type.getJavaType().getRealName();
            if (SimpleToBoxedUtil.isPrimitive(javaName)) {
                if (javaName.equals(Boolean.TYPE.toString())) {
                    cls = Boolean.TYPE;
                } else if (javaName.equals(ModelerConstants.BYTE_CLASSNAME)) {
                    cls = Byte.TYPE;
                } else if (javaName.equals(ModelerConstants.DOUBLE_CLASSNAME)) {
                    cls = Double.TYPE;
                } else if (javaName.equals(ModelerConstants.INT_CLASSNAME)) {
                    cls = Integer.TYPE;
                } else if (javaName.equals(ModelerConstants.FLOAT_CLASSNAME)) {
                    cls = Float.TYPE;
                } else if (javaName.equals(ModelerConstants.LONG_CLASSNAME)) {
                    cls = Long.TYPE;
                } else if (javaName.equals(ModelerConstants.SHORT_CLASSNAME)) {
                    cls = Short.TYPE;
                }
            }
            if (cls == null) {
                cls = javaName.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME) ? (array$B == null ? (array$B = SerializerRegistryGenerator.class$("[B")) : array$B) : Class.forName(javaName);
            }
            if (!((ser = (factory = mapping.getSerializer(cls, type.getName())).getSerializerAs("http://java.sun.com/jax-rpc-ri/1.0/streaming/")) instanceof CombinedSerializer) || !(((CombinedSerializer)ser).getInnermostSerializer() instanceof ValueObjectSerializer)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void writeConstructor(IndentingWriter p, String className) throws IOException {
        StringBuffer stringBuffer = new StringBuffer().append("public ");
        this.env.getNames();
        p.plnI(stringBuffer.append(Names.mangleClass(className)).append("() {").toString());
        p.pOln("}");
    }

    private void writeGetRegistry(IndentingWriter p) throws IOException {
        p.plnI("public TypeMappingRegistry getRegistry() {");
        HashSet<String> processedTypes = new HashSet<String>();
        p.pln();
        p.pln("TypeMappingRegistry registry = BasicService.createStandardTypeMappingRegistry();");
        p.pln("TypeMapping mapping = registry.getTypeMapping(SOAPConstants.NS_SOAP_ENCODING);");
        p.pln("TypeMapping mapping2 = registry.getTypeMapping(\"\");");
        TypeMappingRegistry registry = BasicService.createStandardTypeMappingRegistry();
        TypeMapping mapping = registry.getTypeMapping("http://schemas.xmlsoap.org/soap/encoding/");
        Iterator types = this.visitedTypes.iterator();
        while (types.hasNext()) {
            AbstractType type = (AbstractType)types.next();
            if (type.getJavaType().getName().equals(ModelerConstants.VOID_CLASSNAME) || processedTypes.contains(type.getName() + ";" + type.getJavaType().getRealName())) continue;
            processedTypes.add(type.getName() + ";" + type.getJavaType().getRealName());
            SerializerWriter writer = this.writerFactory.createWriter(type);
            if (writer instanceof SimpleTypeSerializerWriter || writer instanceof CollectionSerializerWriter || writer instanceof DynamicSerializerWriter) {
                if (this.mappingExistsForType(mapping, type)) continue;
                this.warn("generator.serializerRegistryGenerator.warning.no.standard.simpletype.serialzer", new Object[]{type.getName().toString(), type.getJavaType().getRealName()});
            }
            p.plnI("{");
            if (type.isSOAPType()) {
                writer.registerSerializer(p, this.encodeTypes, this.multiRefEncoding, MAPPING);
            } else if (type.isLiteralType()) {
                writer.registerSerializer(p, this.encodeTypes, this.multiRefEncoding, LITERAL_MAPPING);
            }
            p.pOln("}");
        }
        p.pln("return registry;");
        p.pOln("}");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

