/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.WSDLTypeGenerator;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaException;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Input;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.OperationStyle;
import com.sun.xml.rpc.wsdl.document.Output;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.document.soap.SOAPAddress;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBinding;
import com.sun.xml.rpc.wsdl.document.soap.SOAPBody;
import com.sun.xml.rpc.wsdl.document.soap.SOAPFault;
import com.sun.xml.rpc.wsdl.document.soap.SOAPOperation;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import com.sun.xml.rpc.wsdl.framework.DuplicateEntityException;
import com.sun.xml.rpc.wsdl.parser.Constants;
import com.sun.xml.rpc.wsdl.parser.WSDLWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class WSDLGenerator
implements Constants,
ProcessorAction {
    private File destDir;
    private ProcessorEnvironment env;
    private Model model;

    public WSDLGenerator() {
        this.destDir = null;
        this.env = null;
        this.model = null;
    }

    public void perform(Model model, Configuration config, Properties properties) {
        ProcessorEnvironment env = config.getEnvironment();
        String key = "nonclassDestinationDirectory";
        String dirPath = properties.getProperty(key);
        File destDir = new File(dirPath);
        WSDLGenerator generator = new WSDLGenerator(env, destDir, model);
        generator.doGeneration();
    }

    private WSDLGenerator(ProcessorEnvironment env, File destDir, Model model) {
        this.env = env;
        this.model = model;
        this.destDir = destDir;
    }

    private void doGeneration() {
        try {
            this.doGeneration(this.model);
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void doGeneration(Model model) throws Exception {
        File wsdlFile = new File(this.destDir, model.getName().getLocalPart() + ".wsdl");
        WSDLDocument document = this.generateDocument(model);
        try {
            WSDLWriter writer = new WSDLWriter();
            FileOutputStream fos = new FileOutputStream(wsdlFile);
            this.env.addGeneratedFile(wsdlFile);
            writer.write(document, fos);
            fos.close();
        }
        catch (IOException e) {
            this.fail("generator.cant.write", wsdlFile.toString());
        }
    }

    private WSDLDocument generateDocument(Model model) throws Exception {
        WSDLDocument document = new WSDLDocument();
        Definitions definitions = new Definitions(document);
        definitions.setName(model.getName().getLocalPart());
        definitions.setTargetNamespaceURI(model.getTargetNamespaceURI());
        document.setDefinitions(definitions);
        this.generateTypes(model, document);
        this.generateMessages(model, definitions);
        this.generatePortTypes(model, definitions);
        this.generateBindings(model, definitions);
        this.generateServices(model, definitions);
        return document;
    }

    private void generateTypes(Model model, WSDLDocument document) throws Exception {
        WSDLTypeGenerator typeGenerator = new WSDLTypeGenerator(model, document);
        typeGenerator.run();
    }

    private void generateMessages(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                PortType wsdlPortType = new PortType(definitions);
                wsdlPortType.setName(this.getWSDLPortTypeName(port));
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations.next();
                    String localOperationName = operation.getName().getLocalPart();
                    Request request = operation.getRequest();
                    com.sun.xml.rpc.wsdl.document.Message wsdlRequestMessage = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                    wsdlRequestMessage.setName(this.getWSDLInputMessageName(operation));
                    this.fillInMessageParts(request, wsdlRequestMessage);
                    Response response = operation.getResponse();
                    com.sun.xml.rpc.wsdl.document.Message wsdlResponseMessage = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                    wsdlResponseMessage.setName(this.getWSDLOutputMessageName(operation));
                    this.fillInMessageParts(response, wsdlResponseMessage);
                    definitions.add(wsdlRequestMessage);
                    definitions.add(wsdlResponseMessage);
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        com.sun.xml.rpc.wsdl.document.Message wsdlFaultMessage = new com.sun.xml.rpc.wsdl.document.Message(definitions);
                        wsdlFaultMessage.setName(this.getWSDLFaultMessageName(fault));
                        MessagePart part = new MessagePart();
                        part.setName(fault.getBlock().getName().getLocalPart());
                        if (fault.getSubfaults() != null) {
                            JavaException javaException = fault.getJavaException();
                            part.setDescriptorKind(SchemaKinds.XSD_TYPE);
                            part.setDescriptor(((SOAPType)javaException.getOwner()).getName());
                        } else {
                            AbstractType type = fault.getBlock().getType();
                            if (type.isSOAPType()) {
                                part.setDescriptorKind(SchemaKinds.XSD_TYPE);
                                part.setDescriptor(type.getName());
                            }
                        }
                        wsdlFaultMessage.add(part);
                        try {
                            definitions.add(wsdlFaultMessage);
                        }
                        catch (DuplicateEntityException e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private void fillInMessageParts(Message message, com.sun.xml.rpc.wsdl.document.Message wsdlMessage) throws Exception {
        Iterator parameters = message.getParameters();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            MessagePart part = new MessagePart();
            part.setName(parameter.getName());
            AbstractType type = parameter.getType();
            if (type.getName() == null) continue;
            if (type.isSOAPType()) {
                part.setDescriptorKind(SchemaKinds.XSD_TYPE);
                part.setDescriptor(type.getName());
            }
            wsdlMessage.add(part);
        }
    }

    private void generatePortTypes(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                PortType wsdlPortType = new PortType(definitions);
                wsdlPortType.setName(this.getWSDLPortTypeName(port));
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations.next();
                    String localOperationName = operation.getName().getLocalPart();
                    Operation wsdlOperation = new Operation();
                    wsdlOperation.setName(localOperationName);
                    wsdlOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
                    String paramOrder = "";
                    Iterator parameters = operation.getRequest().getParameters();
                    int i = 0;
                    while (parameters.hasNext()) {
                        if (i > 0) {
                            paramOrder = paramOrder + " ";
                        }
                        Parameter parameter = (Parameter)parameters.next();
                        paramOrder = paramOrder + parameter.getName();
                        ++i;
                    }
                    wsdlOperation.setParameterOrder(paramOrder);
                    Input input = new Input();
                    input.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLInputMessageName(operation)));
                    wsdlOperation.setInput(input);
                    Output output = new Output();
                    output.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLOutputMessageName(operation)));
                    wsdlOperation.setOutput(output);
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        com.sun.xml.rpc.wsdl.document.Fault wsdlFault = new com.sun.xml.rpc.wsdl.document.Fault();
                        wsdlFault.setName(fault.getName());
                        wsdlFault.setMessage(new QName(model.getTargetNamespaceURI(), this.getWSDLFaultMessageName(fault)));
                        wsdlOperation.addFault(wsdlFault);
                    }
                    wsdlPortType.add(wsdlOperation);
                }
                definitions.add(wsdlPortType);
            }
        }
    }

    private void generateBindings(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                boolean isMixed = false;
                SOAPStyle defaultStyle = null;
                Iterator operations = port.getOperations();
                while (operations.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations.next();
                    if (operation.getStyle() == null) {
                        operation.setStyle(SOAPStyle.RPC);
                    }
                    if (defaultStyle == null) {
                        defaultStyle = operation.getStyle();
                        continue;
                    }
                    if (defaultStyle == operation.getStyle()) continue;
                    isMixed = true;
                }
                String localPortName = port.getName().getLocalPart();
                Binding wsdlBinding = new Binding(definitions);
                wsdlBinding.setName(this.getWSDLBindingName(port));
                wsdlBinding.setPortType(new QName(model.getTargetNamespaceURI(), this.getWSDLPortTypeName(port)));
                SOAPBinding soapBinding = new SOAPBinding();
                if (defaultStyle != null && !isMixed) {
                    soapBinding.setStyle(defaultStyle);
                }
                soapBinding.setTransport("http://schemas.xmlsoap.org/soap/http");
                wsdlBinding.addExtension(soapBinding);
                Iterator operations2 = port.getOperations();
                while (operations2.hasNext()) {
                    com.sun.xml.rpc.processor.model.Operation operation = (com.sun.xml.rpc.processor.model.Operation)operations2.next();
                    BindingOperation wsdlOperation = new BindingOperation();
                    wsdlOperation.setName(operation.getName().getLocalPart());
                    wsdlOperation.setStyle(OperationStyle.REQUEST_RESPONSE);
                    SOAPOperation soapOperation = new SOAPOperation();
                    soapOperation.setSOAPAction(operation.getSOAPAction());
                    if (!operation.getStyle().equals(defaultStyle)) {
                        soapOperation.setStyle(operation.getStyle());
                    }
                    wsdlOperation.addExtension(soapOperation);
                    Request request = operation.getRequest();
                    BindingInput input = new BindingInput();
                    SOAPBody soapBody = new SOAPBody();
                    if (request.isBodyEmpty()) {
                        if (operation.getStyle() == SOAPStyle.RPC) {
                            soapBody.setUse(SOAPUse.ENCODED);
                            soapBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                            soapBody.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            soapBody.setUse(SOAPUse.LITERAL);
                        }
                    } else if (request.isBodyEncoded()) {
                        soapBody.setUse(SOAPUse.ENCODED);
                        soapBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                        soapBody.setNamespace(model.getTargetNamespaceURI());
                    } else {
                        soapBody.setUse(SOAPUse.LITERAL);
                    }
                    input.addExtension(soapBody);
                    wsdlOperation.setInput(input);
                    Response response = operation.getResponse();
                    BindingOutput output = new BindingOutput();
                    soapBody = new SOAPBody();
                    if (response.isBodyEmpty()) {
                        if (operation.getStyle() == SOAPStyle.RPC) {
                            soapBody.setUse(SOAPUse.ENCODED);
                            soapBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                            soapBody.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            soapBody.setUse(SOAPUse.LITERAL);
                        }
                    } else if (response.isBodyEncoded()) {
                        soapBody.setUse(SOAPUse.ENCODED);
                        soapBody.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                        soapBody.setNamespace(model.getTargetNamespaceURI());
                    } else {
                        soapBody.setUse(SOAPUse.LITERAL);
                    }
                    output.addExtension(soapBody);
                    wsdlOperation.setOutput(output);
                    TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
                    faultSet.addAll(operation.getFaultsSet());
                    Iterator faults = faultSet.iterator();
                    while (faults.hasNext()) {
                        Fault fault = (Fault)faults.next();
                        BindingFault bindingFault = new BindingFault();
                        bindingFault.setName(fault.getName());
                        SOAPFault soapFault = new SOAPFault();
                        if (fault.getBlock().getType().isSOAPType()) {
                            soapFault.setUse(SOAPUse.ENCODED);
                            soapFault.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
                            soapFault.setNamespace(model.getTargetNamespaceURI());
                        } else {
                            soapFault.setUse(SOAPUse.LITERAL);
                        }
                        bindingFault.addExtension(soapFault);
                        wsdlOperation.addFault(bindingFault);
                    }
                    wsdlBinding.add(wsdlOperation);
                }
                definitions.add(wsdlBinding);
            }
        }
    }

    private void generateServices(Model model, Definitions definitions) throws Exception {
        Iterator services = model.getServices();
        while (services.hasNext()) {
            com.sun.xml.rpc.processor.model.Service service = (com.sun.xml.rpc.processor.model.Service)services.next();
            Service wsdlService = new Service(definitions);
            wsdlService.setName(service.getName().getLocalPart());
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                String localPortName = port.getName().getLocalPart();
                com.sun.xml.rpc.wsdl.document.Port wsdlPort = new com.sun.xml.rpc.wsdl.document.Port(definitions);
                wsdlPort.setName(this.getWSDLPortName(port));
                wsdlPort.setBinding(new QName(model.getTargetNamespaceURI(), this.getWSDLBindingName(port)));
                SOAPAddress soapAddress = new SOAPAddress();
                soapAddress.setLocation(port.getAddress() == null ? "REPLACE_WITH_ACTUAL_URL" : port.getAddress());
                wsdlPort.addExtension(soapAddress);
                wsdlService.add(wsdlPort);
            }
            definitions.add(wsdlService);
        }
    }

    private String getWSDLBaseName(Port port) {
        return port.getName().getLocalPart();
    }

    private String getWSDLPortName(Port port) {
        QName value = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        if (value != null) {
            return value.getLocalPart();
        }
        return this.getWSDLBaseName(port) + "Port";
    }

    private String getWSDLBindingName(Port port) {
        QName value = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        if (value != null) {
            return value.getLocalPart();
        }
        return this.getWSDLBaseName(port) + "Binding";
    }

    private String getWSDLPortTypeName(Port port) {
        QName value = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        if (value != null) {
            return value.getLocalPart();
        }
        return port.getName().getLocalPart();
    }

    private String getWSDLInputMessageName(com.sun.xml.rpc.processor.model.Operation operation) {
        QName value = (QName)operation.getRequest().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return operation.getName().getLocalPart();
    }

    private String getWSDLOutputMessageName(com.sun.xml.rpc.processor.model.Operation operation) {
        QName value = (QName)operation.getResponse().getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return operation.getName().getLocalPart() + "Response";
    }

    private String getWSDLFaultMessageName(Fault fault) {
        QName value = (QName)fault.getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
        if (value != null) {
            return value.getLocalPart();
        }
        return fault.getName();
    }

    protected void fail(String key, String arg) {
        throw new GeneratorException(key, arg);
    }
}

