/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.LiteralSerializerWriterBase;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import java.io.IOException;

public class LiteralFragmentSerializerWriter
extends LiteralSerializerWriterBase
implements GeneratorConstants {
    private String serializerMemberName;

    public LiteralFragmentSerializerWriter(LiteralFragmentType type, Names names) {
        super(type, names);
        String serializerName = GeneratorConstants.LITERAL_FRAGMENT_SERIALIZER_NAME;
        this.serializerMemberName = names.getLiteralFragmentTypeSerializerMemberName(type);
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        LiteralFragmentType type = (LiteralFragmentType)this.type;
        String nillable = type.isNillable() ? "NULLABLE" : "NOT_NULLABLE";
        String encodeType = encodeTypes ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        this.declareType(p, typeName, type.getName(), false, false);
        p.pln(this.serializerName() + " " + serName + " = new " + GeneratorConstants.LITERAL_FRAGMENT_SERIALIZER_NAME + "(" + typeName + ", " + nillable + ", \"\");");
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName + ";");
    }

    public String serializerMemberName() {
        return this.serializerMemberName;
    }

    public String deserializerMemberName() {
        return this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }
}

