/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.util.BatchEnvironment;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public class RemoteClass
implements RmiConstants,
Constants {
    private BatchEnvironment env;
    private ClassDefinition implClassDef;
    private ClassDefinition[] remoteInterfaces;
    private Method[] remoteMethods;
    private ClassDefinition defRemote;
    private ClassDefinition defException;
    private ClassDefinition defRemoteException;

    public static RemoteClass forClass(BatchEnvironment env, ClassDefinition implClassDef) {
        RemoteClass rc = new RemoteClass(env, implClassDef);
        if (rc.initialize()) {
            return rc;
        }
        return null;
    }

    public ClassDefinition getClassDefinition() {
        return this.implClassDef;
    }

    public Identifier getName() {
        return this.implClassDef.getName();
    }

    public ClassDefinition[] getRemoteInterfaces() {
        return (ClassDefinition[])this.remoteInterfaces.clone();
    }

    public Method[] getRemoteMethods() {
        return (Method[])this.remoteMethods.clone();
    }

    public String toString() {
        return "remote class " + this.implClassDef.getName().toString();
    }

    private RemoteClass(BatchEnvironment env, ClassDefinition implClassDef) {
        this.env = env;
        this.implClassDef = implClassDef;
    }

    private boolean initialize() {
        try {
            this.defRemote = this.env.getClassDeclaration(Identifier.lookup((String)RmiConstants.REMOTE_CLASSNAME)).getClassDefinition((Environment)this.env);
            this.defException = this.env.getClassDeclaration(Identifier.lookup((String)RmiConstants.EXCEPTION_CLASSNAME)).getClassDefinition((Environment)this.env);
            this.defRemoteException = this.env.getClassDeclaration(Identifier.lookup((String)RmiConstants.REMOTE_EXCEPTION_CLASSNAME)).getClassDefinition((Environment)this.env);
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        Vector<ClassDefinition> remotesImplemented = new Vector<ClassDefinition>();
        ClassDefinition classDef = this.implClassDef;
        while (classDef != null) {
            try {
                ClassDeclaration[] interfaces = classDef.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    ClassDefinition interfaceDef = interfaces[i].getClassDefinition((Environment)this.env);
                    if (!remotesImplemented.contains(interfaceDef) && this.defRemote.implementedBy((Environment)this.env, interfaces[i])) {
                        remotesImplemented.addElement(interfaceDef);
                    }
                    ++i;
                }
                if (classDef == this.implClassDef && remotesImplemented.isEmpty()) {
                    if (this.defRemote.implementedBy((Environment)this.env, this.implClassDef.getClassDeclaration())) {
                        throw new ModelerException("rmimodeler.must.implement.remote.directly", this.implClassDef.getName().toString());
                    }
                    throw new ModelerException("rmimodeler.must.implement.remote", this.implClassDef.getName().toString());
                }
                classDef = classDef.getSuperClass() != null ? classDef.getSuperClass().getClassDefinition((Environment)this.env) : null;
            }
            catch (ClassNotFound e) {
                throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
            }
        }
        int i = 0;
        while (i > remotesImplemented.size()) {
            ClassDefinition interfaceDef = (ClassDefinition)remotesImplemented.elementAt(i);
            boolean isOtherwiseImplemented = false;
            int j = 0;
            while (j < remotesImplemented.size()) {
                try {
                    if (j != i && interfaceDef.implementedBy((Environment)this.env, ((ClassDefinition)remotesImplemented.elementAt(j)).getClassDeclaration())) {
                        isOtherwiseImplemented = true;
                        break;
                    }
                }
                catch (ClassNotFound e) {
                    // empty catch block
                }
                ++j;
            }
            if (isOtherwiseImplemented) {
                remotesImplemented.removeElementAt(i);
                continue;
            }
            ++i;
        }
        Hashtable methods = new Hashtable();
        boolean errors = false;
        try {
            if (this.implClassDef.isInterface() && this.defRemote.implementedBy((Environment)this.env, this.implClassDef.getClassDeclaration()) && !this.collectRemoteMethods(this.implClassDef, methods)) {
                errors = true;
            }
        }
        catch (ClassNotFound e) {
            // empty catch block
        }
        Enumeration enumeration = remotesImplemented.elements();
        while (enumeration.hasMoreElements()) {
            ClassDefinition interfaceDef = (ClassDefinition)enumeration.nextElement();
            if (this.collectRemoteMethods(interfaceDef, methods)) continue;
            errors = true;
        }
        if (errors) {
            return false;
        }
        this.remoteInterfaces = new ClassDefinition[remotesImplemented.size()];
        remotesImplemented.copyInto(this.remoteInterfaces);
        String[] orderedKeys = new String[methods.size()];
        int count = 0;
        Enumeration enum2 = methods.elements();
        while (enum2.hasMoreElements()) {
            Method m = (Method)enum2.nextElement();
            String key = m.getNameAndDescriptor();
            int i2 = count;
            while (i2 > 0) {
                if (key.compareTo(orderedKeys[i2 - 1]) >= 0) break;
                orderedKeys[i2] = orderedKeys[i2 - 1];
                --i2;
            }
            orderedKeys[i2] = key;
            ++count;
        }
        this.remoteMethods = new Method[methods.size()];
        int i3 = 0;
        while (i3 < this.remoteMethods.length) {
            this.remoteMethods[i3] = (Method)methods.get(orderedKeys[i3]);
            ++i3;
        }
        return true;
    }

    private boolean collectRemoteMethods(ClassDefinition interfaceDef, Hashtable table) {
        if (!interfaceDef.isInterface()) {
            throw new Error("expected interface, not class: " + interfaceDef.getName());
        }
        boolean errors = false;
        MemberDefinition member = interfaceDef.getFirstMember();
        while (member != null) {
            if (member.isMethod() && !member.isConstructor() && !member.isInitializer()) {
                ClassDeclaration[] exceptions = member.getExceptions((Environment)this.env);
                boolean hasRemoteException = false;
                int i = 0;
                while (i < exceptions.length) {
                    try {
                        if (this.defRemoteException.subClassOf((Environment)this.env, exceptions[i])) {
                            hasRemoteException = true;
                            break;
                        }
                    }
                    catch (ClassNotFound e) {
                        throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
                    }
                    ++i;
                }
                if (!hasRemoteException) {
                    throw new ModelerException("rmimodeler.must.throw.remoteexception", new Object[]{interfaceDef.getName().toString(), member.toString()});
                }
                try {
                    MemberDefinition implMethod = this.implClassDef.findMethod((Environment)this.env, member.getName(), member.getType());
                    if (implMethod != null) {
                        exceptions = implMethod.getExceptions((Environment)this.env);
                        int i2 = 0;
                        while (i2 < exceptions.length) {
                            if (!this.defException.superClassOf((Environment)this.env, exceptions[i2])) {
                                throw new ModelerException("rmimodeler.must.only.throw.exception", new Object[]{implMethod.toString(), exceptions[i2].getName().toString()});
                            }
                            ++i2;
                        }
                    }
                }
                catch (ClassNotFound e) {
                    throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
                }
                Method newMethod = new Method(member);
                String key = newMethod.getNameAndDescriptor();
                Method oldMethod = (Method)table.get(key);
                if (oldMethod != null && (newMethod = newMethod.mergeWith(oldMethod)) == null) {
                    errors = true;
                } else {
                    table.put(key, newMethod);
                }
            }
            member = member.getNextMember();
        }
        try {
            ClassDeclaration[] superDefs = interfaceDef.getInterfaces();
            int i = 0;
            while (i < superDefs.length) {
                ClassDefinition superDef = superDefs[i].getClassDefinition((Environment)this.env);
                if (!this.collectRemoteMethods(superDef, table)) {
                    errors = true;
                }
                ++i;
            }
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        return !errors;
    }

    private void sortClassDeclarations(ClassDeclaration[] decl) {
        int i = 1;
        while (i < decl.length) {
            ClassDeclaration curr = decl[i];
            String name = ClassNameInfo.mangleClass(curr.getName().toString());
            int j = i;
            while (j > 0) {
                if (name.compareTo(ClassNameInfo.mangleClass(decl[j - 1].getName().toString())) >= 0) break;
                decl[j] = decl[j - 1];
                --j;
            }
            decl[j] = curr;
            ++i;
        }
    }

    public class Method
    implements Cloneable {
        private MemberDefinition memberDef;
        private long methodHash;
        private ClassDeclaration[] exceptions;

        public MemberDefinition getMemberDefinition() {
            return this.memberDef;
        }

        public Identifier getName() {
            return this.memberDef.getName();
        }

        public Type getType() {
            return this.memberDef.getType();
        }

        public ClassDeclaration[] getExceptions() {
            return (ClassDeclaration[])this.exceptions.clone();
        }

        public long getMethodHash() {
            return this.methodHash;
        }

        public String toString() {
            return this.memberDef.toString();
        }

        public String getOperationString() {
            return this.memberDef.toString();
        }

        public String getNameAndDescriptor() {
            return this.memberDef.getName().toString() + this.memberDef.getType().getTypeSignature();
        }

        Method(MemberDefinition memberDef) {
            this.memberDef = memberDef;
            this.exceptions = memberDef.getExceptions((Environment)RemoteClass.this.env);
            this.methodHash = this.computeMethodHash();
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("clone failed");
            }
        }

        private Method mergeWith(Method other) {
            if (!this.getName().equals(other.getName()) || !this.getType().equals(other.getType())) {
                throw new Error("attempt to merge method \"" + other.getNameAndDescriptor() + "\" with \"" + this.getNameAndDescriptor());
            }
            Vector legalExceptions = new Vector();
            try {
                this.collectCompatibleExceptions(other.exceptions, this.exceptions, legalExceptions);
                this.collectCompatibleExceptions(this.exceptions, other.exceptions, legalExceptions);
            }
            catch (ClassNotFound e) {
                throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
            }
            Method merged = (Method)this.clone();
            merged.exceptions = new ClassDeclaration[legalExceptions.size()];
            legalExceptions.copyInto(merged.exceptions);
            return merged;
        }

        private void collectCompatibleExceptions(ClassDeclaration[] from, ClassDeclaration[] with, Vector list) throws ClassNotFound {
            int i = 0;
            while (i < from.length) {
                ClassDefinition exceptionDef = from[i].getClassDefinition((Environment)RemoteClass.this.env);
                if (!list.contains(from[i])) {
                    int j = 0;
                    while (j < with.length) {
                        if (exceptionDef.subClassOf((Environment)RemoteClass.this.env, with[j])) {
                            list.addElement(from[i]);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private long computeMethodHash() {
            long hash = 0L;
            ByteArrayOutputStream sink = new ByteArrayOutputStream(512);
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, md));
                String methodString = this.getNameAndDescriptor();
                out.writeUTF(methodString);
                out.flush();
                byte[] hashArray = md.digest();
                int i = 0;
                while (i < Math.min(8, hashArray.length)) {
                    hash += (long)(hashArray[i] & 0xFF) << i * 8;
                    ++i;
                }
            }
            catch (IOException e) {
                throw new Error("unexpected exception computing intetrface hash: " + e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("unexpected exception computing intetrface hash: " + e);
            }
            return hash;
        }
    }
}

