/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.config.ImportedDocumentInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingInfo;
import com.sun.xml.rpc.processor.config.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.TypeMappingRegistryInfo;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.Modeler;
import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.ExceptionModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RemoteClass;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiTypeModeler;
import com.sun.xml.rpc.processor.modeler.rmi.RmiUtils;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreator;
import com.sun.xml.rpc.processor.util.BatchEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.util.ClassNameInfo;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.Type;

public class RmiModeler
implements RmiConstants,
Modeler,
Constants {
    private final String modelName;
    private final String typeUri;
    private final String wsdlUri;
    private final RmiModelInfo modelInfo;
    private BatchEnvironment env;
    private Map structMap;
    private TypeMappingRegistryInfo typeMappingRegistry;
    private Map messageMap;
    private NamespaceMappingRegistryInfo namespaceMappingRegistry;
    private ClassDefinition defHolder;
    private Model model;
    private static final Set excludedInterfaces = new HashSet();
    private static final Class remoteExceptionClass = class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = RmiModeler.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException;
    private RmiTypeModeler rmiTypeModeler;
    private ExceptionModeler exceptionModeler;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public RmiModeler(RmiModelInfo rmiModelInfo) {
        this.modelInfo = rmiModelInfo;
        this.modelName = rmiModelInfo.getName();
        this.typeUri = rmiModelInfo.getTypeNamespaceURI();
        this.wsdlUri = rmiModelInfo.getTargetNamespaceURI();
        this.env = (BatchEnvironment)rmiModelInfo.getConfiguration().getEnvironment();
        this.typeMappingRegistry = rmiModelInfo.getTypeMappingRegistry();
        this.namespaceMappingRegistry = rmiModelInfo.getNamespaceMappingRegistry();
        this.rmiTypeModeler = new RmiTypeModeler(this, this.env);
        this.exceptionModeler = new ExceptionModeler(this);
        try {
            this.defHolder = this.env.getClassDeclaration(Identifier.lookup((String)RmiConstants.HOLDER_CLASSNAME)).getClassDefinition((Environment)this.env);
        }
        catch (ClassNotFound e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
    }

    public BatchEnvironment getBatchEnvironment() {
        return this.env;
    }

    public TypeMappingRegistryInfo getTypeMappingRegistryInfo() {
        return this.typeMappingRegistry;
    }

    public NamespaceMappingRegistryInfo getNamespaceMappingRegistryInfo() {
        return this.namespaceMappingRegistry;
    }

    public ClassDefinition getDefHolder() {
        return this.defHolder;
    }

    public Model getModel() {
        return this.model;
    }

    public SOAPType modelTypeSOAP(String typeUri, Type type) {
        return this.rmiTypeModeler.modelTypeSOAP(typeUri, type);
    }

    public SOAPSimpleTypeCreator getSOAPTypes() {
        return this.rmiTypeModeler.getSOAPTypes();
    }

    protected void addFaultParent(Fault fault) {
        try {
            Class javaClass = RmiUtils.getClassForName(fault.getJavaException().getRealName(), this.env.getClassLoader());
            javaClass = javaClass.getSuperclass();
            if (javaClass != null && !javaClass.getName().equals(RmiConstants.EXCEPTION_CLASSNAME)) {
                ClassDeclaration typeCDec = this.env.getClassDeclaration(Identifier.lookup((String)javaClass.getName()));
                Fault parentFault = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, typeCDec);
                parentFault.addSubfault(fault);
                parentFault.getJavaException().addSubclass(fault.getJavaException());
                Block block = parentFault.getBlock();
                block.setType((AbstractType)parentFault.getJavaException().getOwner());
                this.addFaultParent(parentFault);
                RmiModeler.markInheritedMembers((SOAPStructureType)fault.getJavaException().getOwner(), (SOAPStructureType)parentFault.getJavaException().getOwner());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", fault.getJavaException().getRealName());
        }
    }

    public static void markInheritedMembers(SOAPStructureType type1, SOAPStructureType type2) {
        Iterator members1 = type1.getMembers();
        block0: while (members1.hasNext()) {
            Iterator members2 = type2.getMembers();
            SOAPStructureMember member1 = (SOAPStructureMember)members1.next();
            while (members2.hasNext()) {
                SOAPStructureMember member2 = (SOAPStructureMember)members2.next();
                if (!RmiModeler.membersMatch(member1, member2)) continue;
                member1.setInherited(true);
                member1.getJavaStructureMember().setInherited(true);
                continue block0;
            }
        }
    }

    public static boolean membersMatch(SOAPStructureMember member1, SOAPStructureMember member2) {
        return member1.getName().equals(member2.getName()) && member1.getType().equals(member2.getType());
    }

    public Model buildModel() {
        this.log("creating model: " + this.modelName);
        this.model = new Model(new QName(null, this.modelName));
        this.model.setProperty("com.sun.xml.rpc.processor.model.ModelerName", this.getClass().getName());
        this.model.setTargetNamespaceURI(this.wsdlUri);
        if (this.typeMappingRegistry != null) {
            Iterator iter = this.typeMappingRegistry.getImportedDocuments();
            while (iter.hasNext()) {
                this.model.addImportedDocument((ImportedDocumentInfo)iter.next());
            }
            Iterator iter2 = this.typeMappingRegistry.getExtraTypeNames();
            while (iter2.hasNext()) {
                String typeSig = RmiUtils.getTypeSig((String)iter2.next());
                Type type = Type.tType((String)typeSig);
                if (RmiModeler.isException(this.env, type)) {
                    ClassDeclaration typeCDec = this.env.getClassDeclaration(type);
                    Fault fault = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, typeCDec);
                    this.addFaultParent(fault);
                    continue;
                }
                SOAPType extraType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, type);
                this.model.addExtraType(extraType);
            }
        }
        this.structMap = new HashMap();
        try {
            String javaServiceName = StringUtils.capitalize(this.modelInfo.getName());
            this.log("creating service: " + javaServiceName);
            String serviceInterface = this.modelInfo.getJavaPackageName() != null && !this.modelInfo.getJavaPackageName().equals("") ? this.modelInfo.getJavaPackageName() + "." + javaServiceName : javaServiceName;
            Service service = new Service(new QName(this.wsdlUri, javaServiceName), new JavaInterface(serviceInterface, serviceInterface + "Impl"));
            this.model.addService(service);
            Iterator interfaces = this.modelInfo.getInterfaces();
            while (interfaces.hasNext()) {
                RmiInterfaceInfo interfaceInfo = (RmiInterfaceInfo)interfaces.next();
                service.addPort(this.modelPort(interfaceInfo));
            }
            this.rmiTypeModeler.modelSubclasses(this.typeUri);
            this.messageMap = null;
        }
        catch (ModelerException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new ModelerException(e);
        }
        catch (Exception e) {
            throw new ModelerException(new LocalizableExceptionAdapter(e));
        }
        this.structMap = null;
        return this.model;
    }

    public static boolean isException(BatchEnvironment env, Type type) {
        try {
            if (type.getTypeCode() != 10) {
                return false;
            }
            Class typeClass = RmiUtils.getClassForName(RmiModeler.getRealName(type.toString(), env), env.getClassLoader());
            while (typeClass != null) {
                if (typeClass.getName().equals(RmiConstants.EXCEPTION_CLASSNAME)) {
                    return true;
                }
                typeClass = typeClass.getSuperclass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getRealName(String name, BatchEnvironment env) {
        name = env.getNames().removeWhiteSpace(name);
        String realName = env.getRealName(name);
        int idx1 = realName.indexOf(36);
        if (idx1 > 0 && idx1 != realName.lastIndexOf(36)) {
            throw new ModelerException("rmimodeler.nested.inner.classes.not.supported", name);
        }
        return realName;
    }

    private Port modelPort(RmiInterfaceInfo interfaceInfo) {
        Port port = null;
        String implClassName = RmiModeler.getRealName(interfaceInfo.getName(), this.env);
        ClassDeclaration decl = this.env.getClassDeclaration(Identifier.lookup((String)implClassName));
        try {
            ClassDefinition def = decl.getClassDefinition((Environment)this.env);
            RemoteClass remoteClass = RemoteClass.forClass(this.env, def);
            if (remoteClass == null) {
                throw new ModelerException("rmimodeler.invalid.remote.interface", interfaceInfo.getName());
            }
            port = this.processInterface(remoteClass, implClassName, interfaceInfo);
        }
        catch (ClassNotFound ex) {
            throw new ModelerException("rmimodeler.class.not.found", implClassName.toString());
        }
        return port;
    }

    private Port processInterface(RemoteClass remoteClass, String intfName, RmiInterfaceInfo interfaceInfo) {
        this.messageMap = new HashMap();
        String servant = interfaceInfo.getServantName();
        this.log("creating port: " + remoteClass.getName().toString());
        String portName = ClassNameInfo.getName(remoteClass.getName().toString());
        portName = ClassNameInfo.makeSafeClassName(portName);
        String packageName = this.env.getNames().getPackageName(remoteClass.getName().toString());
        String namespace = this.wsdlUri;
        Port port = new Port(new QName(namespace, portName));
        JavaInterface javaInterface = new JavaInterface(intfName, servant);
        port.setJavaInterface(javaInterface);
        ClassDefinition[] remoteInterfaces = remoteClass.getRemoteInterfaces();
        int i = 0;
        while (i < remoteInterfaces.length) {
            String interfaceName = this.env.getNames().removeCharacter(32, remoteInterfaces[i].getName().toString());
            if (!interfaceName.equals(javaInterface.getName())) {
                javaInterface.addInterface(interfaceName);
            }
            ++i;
        }
        RemoteClass.Method[] methods = remoteClass.getRemoteMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            port.addOperation(this.processMethod(interfaceInfo, remoteClass, methods[i2], namespace));
            ++i2;
        }
        port.setClientHandlerChainInfo(interfaceInfo.getClientHandlerChainInfo());
        port.setServerHandlerChainInfo(interfaceInfo.getServerHandlerChainInfo());
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortName", this.getWSDLPortName(portName));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName", this.getWSDLPortTypeName(portName));
        port.setProperty("com.sun.xml.rpc.processor.model.WSDLBindingName", this.getWSDLBindingName(portName));
        this.messageMap = null;
        return port;
    }

    private String getStructName(String name) {
        String tmp = name.toLowerCase();
        Integer count = (Integer)this.structMap.get(tmp);
        if (count != null) {
            count = new Integer(count + 1);
            name = name + count;
        } else {
            count = new Integer(0);
        }
        this.structMap.put(tmp, count);
        return name;
    }

    private Operation processMethod(RmiInterfaceInfo interfaceInfo, RemoteClass remoteClass, RemoteClass.Method method, String namespaceURI) {
        JavaStructureMember javaMember;
        SOAPStructureMember member;
        String portName = ClassNameInfo.getName(remoteClass.getName().toString());
        portName = ClassNameInfo.makeSafeClassName(portName);
        Type methodType = method.getType();
        Type[] paramTypes = methodType.getArgumentTypes();
        String[] paramNames = this.nameParameters(paramTypes);
        Type returnType = methodType.getReturnType();
        ClassDeclaration[] exceptions = method.getExceptions();
        ClassDefinition cdef = remoteClass.getClassDefinition();
        String messageName = this.getMessageName(cdef, method);
        String operationName = this.getOperationName(messageName);
        String methodName = method.getName().toString();
        this.log("creating operation: " + methodName);
        Operation operation = new Operation(new QName(namespaceURI, operationName));
        operation.setSOAPAction(this.getSOAPAction(interfaceInfo, operationName));
        JavaMethod javaMethod = new JavaMethod(methodName);
        operation.setJavaMethod(javaMethod);
        String packageName = cdef.getName().getQualifier().toString();
        String typeNamespace = this.getNamespaceURI(packageName);
        if (typeNamespace == null) {
            typeNamespace = this.typeUri;
        }
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        RPCResponseStructureType responseStruct = new RPCResponseStructureType(new QName(typeNamespace, StringUtils.capitalize(this.env.getNames().getResponseName(operationName))));
        JavaStructureType javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + StringUtils.capitalize(methodName) + "_ResponseStruct"), false, responseStruct);
        responseStruct.setJavaType(javaStruct);
        Response response = new Response();
        JavaStructureType javaRespStructure = (JavaStructureType)responseStruct.getJavaType();
        Block responseBlock = new Block(new QName(namespaceURI, this.env.getNames().getResponseName(operationName)));
        SOAPType resultType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, returnType);
        if (returnType.getTypeCode() != 11) {
            member = new SOAPStructureMember(new QName(null, "result"), resultType);
            javaMember = new JavaStructureMember(member.getName().getLocalPart(), member.getType().getJavaType(), member, false);
            javaMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            javaRespStructure.add(javaMember);
            responseStruct.add(member);
        }
        response.addBodyBlock(responseBlock);
        Parameter resultParam = new Parameter("result");
        resultParam.setEmbedded(true);
        resultParam.setType(resultType);
        resultParam.setBlock(responseBlock);
        responseBlock.setType(responseStruct);
        JavaParameter javaParameter = new JavaParameter(null, resultType.getJavaType(), resultParam);
        javaMethod.setReturnType(resultType.getJavaType());
        resultParam.setJavaParameter(javaParameter);
        response.addParameter(resultParam);
        response.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLOutputMessageName(portName + "_" + operationName));
        operation.setResponse(response);
        RPCRequestOrderedStructureType paramStruct = new RPCRequestOrderedStructureType(new QName(typeNamespace, StringUtils.capitalize(operationName)));
        javaStruct = new JavaStructureType(this.getStructName(packageName + portName + "_" + paramStruct.getName().getLocalPart() + "_RequestStruct"), false, paramStruct);
        paramStruct.setJavaType(javaStruct);
        Request request = new Request();
        JavaStructureType javaStructure = (JavaStructureType)paramStruct.getJavaType();
        Block block = new Block(new QName(namespaceURI, operationName));
        int i = 0;
        while (i < paramTypes.length) {
            QName typeName = new QName(null, paramNames[i]);
            SOAPType memberType = this.rmiTypeModeler.modelTypeSOAP(this.typeUri, paramTypes[i]);
            boolean isHolder = memberType.getJavaType().isHolder();
            member = new SOAPStructureMember(typeName, memberType);
            javaMember = new JavaStructureMember(member.getName().getLocalPart(), member.getType().getJavaType(), member, false);
            javaMember.setReadMethod(this.env.getNames().getJavaMemberReadMethod(javaMember));
            javaMember.setWriteMethod(this.env.getNames().getJavaMemberWriteMethod(javaMember));
            member.setJavaStructureMember(javaMember);
            javaStructure.add(javaMember);
            paramStruct.add(member);
            Parameter parameter = new Parameter(paramNames[i]);
            if (isHolder) {
                javaRespStructure.add(javaMember);
                responseStruct.add(member);
                Parameter responseParam = new Parameter(paramNames[i]);
                responseParam.setEmbedded(true);
                javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), responseParam, true);
                responseParam.setJavaParameter(javaParameter);
                responseParam.setType(member.getType());
                responseParam.setBlock(responseBlock);
                parameter.setLinkedParameter(responseParam);
                responseParam.setLinkedParameter(parameter);
                response.addParameter(responseParam);
            }
            parameter.setEmbedded(true);
            javaParameter = new JavaParameter(paramNames[i], member.getType().getJavaType(), parameter, isHolder);
            parameter.setJavaParameter(javaParameter);
            parameter.setType(member.getType());
            parameter.setBlock(block);
            javaMethod.addParameter(javaParameter);
            request.addParameter(parameter);
            ++i;
        }
        block.setType(paramStruct);
        request.addBodyBlock(block);
        request.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLInputMessageName(portName + "_" + operationName));
        operation.setRequest(request);
        if (exceptions.length > 0) {
            int i2 = 0;
            while (i2 < exceptions.length) {
                if (!RmiModeler.isRemoteException(this.env, exceptions[i2].getName().toString())) {
                    javaMethod.addException(exceptions[i2].getName().toString());
                    if (!exceptions[i2].getName().toString().equals(RmiConstants.EXCEPTION_CLASSNAME)) {
                        Fault fault = this.exceptionModeler.modelException(this.typeUri, this.wsdlUri, exceptions[i2]);
                        response.addFaultBlock(fault.getBlock());
                        fault.setProperty("com.sun.xml.rpc.processor.model.WSDLMessageName", this.getWSDLFaultMessageName(fault.getName()));
                        operation.addFault(fault);
                        this.addFaultParent(fault);
                    }
                }
                ++i2;
            }
        }
        return operation;
    }

    public static boolean isRemoteException(BatchEnvironment env, String exceptionName) {
        try {
            Class exceptionClass = RmiUtils.getClassForName(exceptionName, env.getClassLoader());
            return remoteExceptionClass.isAssignableFrom(exceptionClass);
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.class.not.found", exceptionName);
        }
    }

    private String[] nameParameters(Type[] types) {
        String[] names = new String[types.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.generateNameFromType(types[i]) + "_" + (i + 1);
            ++i;
        }
        return names;
    }

    private String generateNameFromType(Type type) {
        int typeCode = type.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return type.toString();
            }
            case 9: {
                return "arrayOf" + this.generateNameFromType(type.getElementType());
            }
            case 10: {
                Type holderValueType = RmiTypeModeler.getHolderValueType(this.env, this.defHolder, type);
                if (holderValueType != null) {
                    return this.generateNameFromType(holderValueType);
                }
                String tmp = ClassNameInfo.mangleClass(type.getClassName().getName().toString());
                return ClassNameInfo.replaceInnerClassSym(tmp);
            }
        }
        throw new Error("unexpected type code: " + typeCode);
    }

    public String getMessageName(ClassDefinition cdef, RemoteClass.Method method) {
        return method.getName().toString();
    }

    public String getSOAPAction(RmiInterfaceInfo interfaceInfo, String operationName) {
        if (interfaceInfo.getSOAPAction() != null) {
            return interfaceInfo.getSOAPAction();
        }
        if (interfaceInfo.getSOAPActionBase() != null) {
            return interfaceInfo.getSOAPActionBase() + operationName;
        }
        return "";
    }

    public String getOperationName(String messageName) {
        String operationName = null;
        Integer cnt = (Integer)this.messageMap.get(messageName);
        if (cnt == null) {
            cnt = new Integer(0);
            operationName = messageName;
        }
        this.messageMap.put(messageName, new Integer(cnt + 1));
        if (operationName == null) {
            operationName = messageName + (cnt + 1);
        }
        return operationName;
    }

    public String getNamespaceURI(String javaPackageName) {
        NamespaceMappingInfo i;
        if (this.namespaceMappingRegistry != null && (i = this.namespaceMappingRegistry.getNamespaceMappingInfo(javaPackageName)) != null) {
            return i.getNamespaceURI();
        }
        return null;
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + msg + "]");
        }
    }

    private QName getWSDLPortName(String portName) {
        return new QName(this.wsdlUri, portName + "Port");
    }

    private QName getWSDLBindingName(String portName) {
        return new QName(this.wsdlUri, portName + "Binding");
    }

    private QName getWSDLPortTypeName(String portName) {
        return new QName(this.wsdlUri, portName);
    }

    private QName getWSDLInputMessageName(String operationName) {
        return new QName(this.wsdlUri, operationName);
    }

    private QName getWSDLOutputMessageName(String operationName) {
        return new QName(this.wsdlUri, operationName + "Response");
    }

    private QName getWSDLFaultMessageName(String faultName) {
        return new QName(this.wsdlUri, faultName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        excludedInterfaces.add(RmiConstants.SERIALIZABLE_CLASSNAME);
        excludedInterfaces.add(RmiConstants.HOLDER_CLASSNAME);
        excludedInterfaces.add(RmiConstants.REMOTE_CLASSNAME);
    }
}

