/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class ToolBase {
    protected OutputStream out;
    protected String program;
    protected Localizer localizer;
    protected LocalizableMessageFactory messageFactory;

    public ToolBase(OutputStream out, String program) {
        this.out = out;
        this.program = program;
        this.initialize();
    }

    protected void initialize() {
        this.messageFactory = new LocalizableMessageFactory(this.getResourceBundleName());
        this.localizer = new Localizer();
    }

    public boolean run(String[] args) {
        if (!this.parseArguments(args)) {
            return false;
        }
        try {
            this.run();
            return this.wasSuccessful();
        }
        catch (Exception e) {
            if (e instanceof Localizable) {
                this.report((Localizable)((Object)e));
            } else {
                this.report(this.getMessage(this.getGenericErrorMessage(), e.toString()));
            }
            this.printStackTrace(e);
            return false;
        }
    }

    public boolean wasSuccessful() {
        return true;
    }

    protected abstract boolean parseArguments(String[] var1);

    protected abstract void run() throws Exception;

    protected abstract String getGenericErrorMessage();

    protected abstract String getResourceBundleName();

    public void printStackTrace(Throwable t) {
        PrintStream outstream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        t.printStackTrace(outstream);
        outstream.flush();
    }

    protected void report(String msg) {
        PrintStream outstream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        outstream.println(msg);
        outstream.flush();
    }

    protected void report(Localizable msg) {
        this.report(this.localizer.localize(msg));
    }

    public Localizable getMessage(String key) {
        return this.getMessage(key, (Object[])null);
    }

    public Localizable getMessage(String key, String arg) {
        return this.messageFactory.getMessage(key, new Object[]{arg});
    }

    public Localizable getMessage(String key, String arg1, String arg2) {
        return this.messageFactory.getMessage(key, new Object[]{arg1, arg2});
    }

    public Localizable getMessage(String key, String arg1, String arg2, String arg3) {
        return this.messageFactory.getMessage(key, new Object[]{arg1, arg2, arg3});
    }

    public Localizable getMessage(String key, Localizable localizable) {
        return this.messageFactory.getMessage(key, new Object[]{localizable});
    }

    public Localizable getMessage(String key, Object[] args) {
        return this.messageFactory.getMessage(key, args);
    }
}

