/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.framework;

import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import com.sun.xml.rpc.wsdl.framework.ParserListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ParserContext {
    private static final String PREFIX_XMLNS = "xmlns";
    private boolean _followImports;
    private AbstractDocument _document;
    private NamespaceSupport _nsSupport;
    private ArrayList _listeners;

    public ParserContext(AbstractDocument doc, ArrayList listeners) {
        this._document = doc;
        this._listeners = listeners;
        this._nsSupport = new NamespaceSupport();
    }

    public AbstractDocument getDocument() {
        return this._document;
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean b) {
        this._followImports = b;
    }

    public void push() {
        this._nsSupport.pushContext();
    }

    public void pop() {
        this._nsSupport.popContext();
    }

    public String getNamespaceURI(String prefix) {
        return this._nsSupport.getURI(prefix);
    }

    public Iterator getPrefixes() {
        return this._nsSupport.getPrefixes();
    }

    public String getDefaultNamespaceURI() {
        return this.getNamespaceURI("");
    }

    public void registerNamespaces(Element e) {
        Iterator iter = XmlUtil.getAllAttributes(e);
        while (iter.hasNext()) {
            Attr a = (Attr)iter.next();
            if (a.getName().equals(PREFIX_XMLNS)) {
                this._nsSupport.declarePrefix("", a.getValue());
                continue;
            }
            String prefix = XmlUtil.getPrefix(a.getName());
            if (prefix == null || !prefix.equals(PREFIX_XMLNS)) continue;
            String nsPrefix = XmlUtil.getLocalPart(a.getName());
            String uri = a.getValue();
            this._nsSupport.declarePrefix(nsPrefix, uri);
        }
    }

    public QName translateQualifiedName(String s) {
        if (s == null) {
            return null;
        }
        String prefix = XmlUtil.getPrefix(s);
        String uri = null;
        if (prefix == null) {
            uri = this.getDefaultNamespaceURI();
        } else {
            uri = this.getNamespaceURI(prefix);
            if (uri == null) {
                throw new ParseException("parsing.unknownNamespacePrefix", prefix);
            }
        }
        return new QName(uri, XmlUtil.getLocalPart(s));
    }

    public void fireIgnoringExtension(QName name, QName parent) {
        List _targets = null;
        ParserContext parserContext = this;
        synchronized (parserContext) {
            if (this._listeners != null) {
                _targets = (List)this._listeners.clone();
            }
        }
        if (_targets != null) {
            Iterator iter = _targets.iterator();
            while (iter.hasNext()) {
                ParserListener l = (ParserListener)iter.next();
                l.ignoringExtension(name, parent);
            }
        }
    }

    public void fireDoneParsingEntity(QName element, Entity entity) {
        List _targets = null;
        ParserContext parserContext = this;
        synchronized (parserContext) {
            if (this._listeners != null) {
                _targets = (List)this._listeners.clone();
            }
        }
        if (_targets != null) {
            Iterator iter = _targets.iterator();
            while (iter.hasNext()) {
                ParserListener l = (ParserListener)iter.next();
                l.doneParsingEntity(element, entity);
            }
        }
    }
}

