/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class ConceptImpl
extends RegistryObjectImpl
implements Concept,
Serializable {
    transient boolean childrenLoaded = false;
    transient boolean isPredefined = false;
    String value;
    ConceptImpl parentConcept;
    ClassificationScheme classificationScheme;
    ArrayList children = new ArrayList();

    public ConceptImpl() {
    }

    public ConceptImpl(Key key) {
        this();
        this.key = key;
    }

    public ConceptImpl(Key key, String string, String string2) {
        this(key);
        this.description = new InternationalStringImpl(string);
        this.name = new InternationalStringImpl(string2);
    }

    public ConceptImpl(RegistryObject registryObject, String string, String string2) throws JAXRException {
        this();
        if (registryObject instanceof ClassificationScheme) {
            ((ClassificationScheme)registryObject).addChildConcept((Concept)this);
        } else if (registryObject instanceof Concept) {
            ((Concept)registryObject).addChildConcept((Concept)this);
        }
        this.name = new InternationalStringImpl(string);
        this.value = string2;
    }

    public String getValue() throws JAXRException {
        if (this.value == null) {
            this.getObject();
        }
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
        this.setIsModified(true);
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        if (concept != null && !this.children.contains(concept)) {
            ((ConceptImpl)concept).setParentConcept(this);
            this.children.add(concept);
            this.setIsModified(true);
        }
    }

    public void addChildConcepts(Collection collection) throws JAXRException {
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                Concept concept = (Concept)iterator.next();
                this.addChildConcept(concept);
            }
        }
        catch (ClassCastException classCastException) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Objects_in_collection_must_be_concepts"), (Throwable)classCastException);
        }
    }

    public void removeChildConcept(Concept concept) {
        if (concept != null) {
            ((AbstractCollection)this.children).remove(concept);
            this.setIsModified(true);
        }
    }

    public void removeChildConcepts(Collection collection) {
        if (collection != null) {
            ((AbstractCollection)this.children).removeAll(collection);
            this.setIsModified(true);
        }
    }

    public int getChildConceptCount() {
        return this.children.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return (Collection)this.children.clone();
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList arrayList = new ArrayList(this.children);
        Iterator iterator = ((AbstractList)this.children).iterator();
        while (iterator.hasNext()) {
            Concept concept = (Concept)iterator.next();
            if (concept.getChildConceptCount() <= 0) continue;
            arrayList.addAll(concept.getDescendantConcepts());
        }
        return arrayList;
    }

    public Concept getParentConcept() throws JAXRException {
        return this.parentConcept;
    }

    public ClassificationScheme getClassificationScheme() throws JAXRException {
        if (this.classificationScheme != null) {
            return this.classificationScheme;
        }
        return this.parentConcept != null ? this.parentConcept.getClassificationScheme() : null;
    }

    public void setClassificationScheme(ClassificationScheme classificationScheme) {
        this.classificationScheme = classificationScheme;
    }

    public String getPath() throws JAXRException {
        if (this.parentConcept == null) {
            return this.classificationScheme.getKey().getId() + "/" + this.value;
        }
        return this.parentConcept.getPath() + "/" + this.value;
    }

    public RegistryObject getParent() {
        if (this.parentConcept != null) {
            return this.parentConcept;
        }
        return this.classificationScheme;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public void setPredefined(boolean bl) {
        this.isPredefined = bl;
    }

    public boolean getChildrenLoaded() throws JAXRException {
        return this.childrenLoaded;
    }

    public void setParentConcept(Concept concept) {
        if (concept instanceof ConceptImpl) {
            this.parentConcept = (ConceptImpl)concept;
        }
    }

    public void addExternalLink(ExternalLink externalLink) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (externalLink != null) {
            ExternalLinkImpl externalLinkImpl = (ExternalLinkImpl)externalLink;
            externalLinkImpl.addLinkedObject(this);
            this.externalLinks.add(externalLinkImpl);
            this.setIsModified(true);
        }
    }

    public void addExternalLinks(Collection collection) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (collection != null) {
            if (collection.size() > 1) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Cannot_add_more_than_one_ExternalLink"));
            }
            Iterator iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    this.addExternalLink((ExternalLink)iterator.next());
                }
            }
            catch (ClassCastException classCastException) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Objects_in_collection_must_be_ExternalLinks"), (Throwable)classCastException);
            }
        }
    }

    public void setExternalLinks(Collection collection) throws JAXRException {
        if (collection == null) {
            this.externalLinks.clear();
            return;
        }
        if (collection.size() > 1) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Cannot_set_more_than_one_link."));
        }
        this.externalLinks.clear();
        this.addExternalLinks(collection);
    }
}

