/*
 * Decompiled with CFR 0.152.
 */
package de.wartala.eclipse.IpkDeploy;

import de.wartala.eclipse.IpkDeploy.ClassConstantsReflector;
import de.wartala.eclipse.IpkDeploy.Control;
import de.wartala.eclipse.IpkDeploy.IpkDeployMessage;
import de.wartala.eclipse.IpkDeploy.Ipkg;
import de.wartala.eclipse.IpkDeploy.IpkgStreamWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class IpkDeployWizardPage
extends WizardPage {
    static final String[] RESOURCE_FILTERS = new String[]{"*.jar", "*.class", "*.zip", "*.png", "*.jpg", "*.gif", "*.html", "*.htm", "*.*"};
    private Button addRes;
    private Button removeRes;
    private Label projectNameLabel;
    private Label projectTypeLabel;
    private Label versionLabel;
    private Label descriptionLabel;
    private Label providerLabel;
    private Label providerMailLabel;
    private Label resourceLabel;
    private Label iconLabel;
    private Label mainClassLabel;
    private Combo typeCombo;
    private List resourceList;
    private Text projectNameText;
    private Text versionText;
    private Text descriptionText;
    private Text providerText;
    private Text providerMailText;
    private Text iconText;
    private Text mainClassText;
    private FileDialog addResFileDialog;
    private int selectedIndex;
    private String projectNameStr;
    private String projectTypeStr;
    private String versionStr;
    private String descriptionStr;
    private String providerStr;
    private String providerMailStr;
    private String iconStr;
    private String mainClassStr;
    private Properties classMap;

    public IpkDeployWizardPage() {
        super("IPK Deploy", IpkDeployMessage.getString("WindowTitle"), null);
        this.setDescription(IpkDeployMessage.getString("WizardDescription"));
        this.selectedIndex = -1;
        this.projectNameStr = "";
        this.projectTypeStr = "";
        this.versionStr = "";
        this.descriptionStr = "";
        this.providerStr = "";
        this.providerMailStr = "";
        this.iconStr = "";
        this.mainClassStr = "";
        this.classMap = new Properties();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((org.eclipse.swt.widgets.Control)composite);
        Group projectGroup = new Group(composite, 0);
        GridLayout projectGridLayout = new GridLayout();
        projectGridLayout.numColumns = 2;
        projectGroup.setLayout((Layout)projectGridLayout);
        projectGroup.setText(IpkDeployMessage.getString("ProjectProperties"));
        projectGroup.setLayoutData((Object)new GridData(768));
        Composite labelGroup = new Composite((Composite)projectGroup, 0);
        GridLayout labelGroupLayout = new GridLayout();
        labelGroupLayout.numColumns = 1;
        labelGroup.setLayout((Layout)labelGroupLayout);
        GridData labelGroupData = new GridData(1040);
        labelGroupData.widthHint = 90;
        labelGroup.setLayoutData((Object)labelGroupData);
        this.projectNameLabel = new Label(labelGroup, 256);
        this.projectNameLabel.setText(IpkDeployMessage.getString("ProjectLabelText"));
        GridData projectNameData = new GridData(768);
        projectNameData.widthHint = 75;
        projectNameData.heightHint = 20;
        this.projectNameLabel.setLayoutData((Object)projectNameData);
        this.projectTypeLabel = new Label(labelGroup, 256);
        this.projectTypeLabel.setText(IpkDeployMessage.getString("ProjectTypeLabelText"));
        GridData projectTypeData = new GridData(768);
        projectTypeData.widthHint = 75;
        projectTypeData.heightHint = 20;
        this.projectTypeLabel.setLayoutData((Object)projectTypeData);
        this.versionLabel = new Label(labelGroup, 256);
        this.versionLabel.setText(IpkDeployMessage.getString("versionLabelText"));
        GridData versionData = new GridData(768);
        versionData.widthHint = 75;
        versionData.heightHint = 20;
        this.versionLabel.setLayoutData((Object)versionData);
        this.descriptionLabel = new Label(labelGroup, 256);
        this.descriptionLabel.setText(IpkDeployMessage.getString("DescriptionLabelText"));
        GridData descriptionData = new GridData(768);
        descriptionData.widthHint = 75;
        descriptionData.heightHint = 20;
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        this.providerLabel = new Label(labelGroup, 256);
        this.providerLabel.setText(IpkDeployMessage.getString("ProviderLabelText"));
        GridData providerData = new GridData(768);
        providerData.widthHint = 75;
        providerData.heightHint = 20;
        this.providerLabel.setLayoutData((Object)providerData);
        this.providerMailLabel = new Label(labelGroup, 256);
        this.providerMailLabel.setText(IpkDeployMessage.getString("ProviderMailLabelText"));
        GridData providerMailData = new GridData(768);
        providerMailData.widthHint = 75;
        providerMailData.heightHint = 20;
        this.providerMailLabel.setLayoutData((Object)providerMailData);
        this.iconLabel = new Label(labelGroup, 256);
        this.iconLabel.setText(IpkDeployMessage.getString("IconLabelText"));
        GridData iconData = new GridData(768);
        iconData.widthHint = 75;
        iconData.heightHint = 20;
        this.iconLabel.setLayoutData((Object)iconData);
        this.mainClassLabel = new Label(labelGroup, 256);
        this.mainClassLabel.setText(IpkDeployMessage.getString("MainLabelText"));
        GridData mainClassData = new GridData(768);
        mainClassData.widthHint = 75;
        mainClassData.heightHint = 20;
        this.mainClassLabel.setLayoutData((Object)mainClassData);
        Composite textGroup = new Composite((Composite)projectGroup, 0);
        GridLayout textGroupLayout = new GridLayout();
        textGroupLayout.numColumns = 1;
        textGroup.setLayout((Layout)textGroupLayout);
        GridData textLayoutData = new GridData(1808);
        textGroup.setLayoutData((Object)textLayoutData);
        this.projectNameText = new Text(textGroup, 2052);
        GridData projectTextData = new GridData(768);
        this.projectNameText.setLayoutData((Object)projectTextData);
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.projectNameText.isDisposed()) {
                    IpkDeployWizardPage.this.projectNameStr = IpkDeployWizardPage.this.projectNameText.getText();
                    System.out.println("Project name is " + IpkDeployWizardPage.this.projectNameStr);
                }
            }
        });
        this.typeCombo = new Combo(textGroup, 8);
        GridData typeComboData = new GridData(768);
        this.typeCombo.setLayoutData((Object)typeComboData);
        this.typeCombo.add(IpkDeployMessage.getString("JavaApplicationText"));
        this.typeCombo.add(IpkDeployMessage.getString("JavaAppletText"));
        this.typeCombo.select(0);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo combo = (Combo)event.getSource();
                int index = combo.getSelectionIndex();
                if (index > -1) {
                    IpkDeployWizardPage.this.projectTypeStr = combo.getItem(index);
                }
            }
        });
        this.versionText = new Text(textGroup, 2052);
        GridData versionTextData = new GridData(768);
        this.versionText.setLayoutData((Object)versionTextData);
        this.versionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.projectNameText.isDisposed()) {
                    IpkDeployWizardPage.this.versionStr = IpkDeployWizardPage.this.versionText.getText();
                    System.out.println("Version is " + IpkDeployWizardPage.this.versionStr);
                }
            }
        });
        this.descriptionText = new Text(textGroup, 2052);
        GridData descriptionTextData = new GridData(768);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.descriptionText.isDisposed()) {
                    IpkDeployWizardPage.this.descriptionStr = IpkDeployWizardPage.this.descriptionText.getText();
                    System.out.println("Description is " + IpkDeployWizardPage.this.descriptionStr);
                }
            }
        });
        this.providerText = new Text(textGroup, 2052);
        GridData providerTextData = new GridData(768);
        this.providerText.setLayoutData((Object)providerTextData);
        this.providerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.providerText.isDisposed()) {
                    IpkDeployWizardPage.this.providerStr = IpkDeployWizardPage.this.providerText.getText();
                    System.out.println("Provider is " + IpkDeployWizardPage.this.providerStr);
                }
            }
        });
        this.providerMailText = new Text(textGroup, 2052);
        GridData providerMailTextData = new GridData(768);
        this.providerMailText.setLayoutData((Object)providerMailTextData);
        this.providerMailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.providerMailText.isDisposed()) {
                    IpkDeployWizardPage.this.providerMailStr = IpkDeployWizardPage.this.providerText.getText();
                    System.out.println("Provider email is " + IpkDeployWizardPage.this.providerMailStr);
                }
            }
        });
        this.iconText = new Text(textGroup, 2052);
        GridData iconTextTextData = new GridData(768);
        this.iconText.setLayoutData((Object)iconTextTextData);
        this.iconText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.iconText.isDisposed()) {
                    IpkDeployWizardPage.this.iconStr = IpkDeployWizardPage.this.iconText.getText();
                    System.out.println("Icon is " + IpkDeployWizardPage.this.iconStr);
                }
            }
        });
        this.mainClassText = new Text(textGroup, 2052);
        this.mainClassText.setEditable(false);
        GridData mainClassTextData = new GridData(768);
        this.mainClassText.setLayoutData((Object)mainClassTextData);
        this.mainClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IpkDeployWizardPage.this.mainClassText.isDisposed()) {
                    IpkDeployWizardPage.this.mainClassStr = IpkDeployWizardPage.this.mainClassText.getText();
                    System.out.println("Main class is " + IpkDeployWizardPage.this.mainClassStr);
                }
            }
        });
        Group resourceGroup = new Group(composite, 0);
        GridLayout resourceGridLayout = new GridLayout();
        resourceGridLayout.numColumns = 2;
        resourceGroup.setLayout((Layout)resourceGridLayout);
        resourceGroup.setText(IpkDeployMessage.getString("ResourceProperties"));
        resourceGroup.setLayoutData((Object)new GridData(768));
        Composite buttonGroup = new Composite((Composite)resourceGroup, 0);
        GridLayout buttonGroupLayout = new GridLayout();
        buttonGroupLayout.numColumns = 1;
        buttonGroup.setLayout((Layout)buttonGroupLayout);
        GridData buttonLayoutData = new GridData(1040);
        buttonLayoutData.widthHint = 90;
        buttonGroup.setLayoutData((Object)buttonLayoutData);
        this.addRes = new Button(buttonGroup, 8);
        this.addRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block12: {
                    String lastPath = null;
                    ClassConstantsReflector ccr = new ClassConstantsReflector();
                    IpkDeployWizardPage.this.addResFileDialog = new FileDialog(IpkDeployWizardPage.this.getShell(), 4096);
                    IpkDeployWizardPage.this.addResFileDialog.setText(IpkDeployMessage.getString("AddResourceFileDialogTitle"));
                    IpkDeployWizardPage.this.addResFileDialog.setFilterExtensions(RESOURCE_FILTERS);
                    if (lastPath != null) {
                        IpkDeployWizardPage.this.addResFileDialog.setFilterPath(lastPath);
                    }
                    String filename = IpkDeployWizardPage.this.addResFileDialog.open();
                    lastPath = IpkDeployWizardPage.this.addResFileDialog.getFilterPath();
                    if (filename == null) {
                        return;
                    }
                    IpkDeployWizardPage.this.resourceList.add(filename);
                    if (filename.endsWith(".JAR") || filename.endsWith(".jar")) {
                        String jarMainClass = null;
                        try {
                            System.out.println("filename is " + filename);
                            jarMainClass = IpkgStreamWriter.getMainClassName(filename);
                            if (jarMainClass != null) {
                                IpkDeployWizardPage.this.mainClassText.setText(jarMainClass);
                                IpkDeployWizardPage.this.classMap.put(jarMainClass, filename);
                                break block12;
                            }
                            IpkDeployWizardPage.this.mainClassText.setText("No main class found");
                        }
                        catch (IOException e) {
                            IpkDeployWizardPage.this.mainClassText.setText("No main class found");
                        }
                    } else if (filename.endsWith(".class") || filename.endsWith(".CLASS")) {
                        try {
                            String classname = ccr.getFullyQualifiedDottedName(filename);
                            IpkDeployWizardPage.this.classMap.put(classname, filename);
                        }
                        catch (IOException e) {}
                    } else if (filename.endsWith(".png") || filename.endsWith(".PNG")) {
                        IpkDeployWizardPage.this.iconText.setText(filename);
                    }
                }
            }
        });
        this.addRes.setText(IpkDeployMessage.getString("AddButtonLabelText"));
        GridData addResData = new GridData(768);
        addResData.widthHint = 75;
        addResData.heightHint = 25;
        this.addRes.setLayoutData((Object)addResData);
        this.removeRes = new Button(buttonGroup, 8);
        this.removeRes.setText(IpkDeployMessage.getString("RemoveButtonLabelText"));
        GridData removeResData = new GridData(768);
        removeResData.widthHint = 75;
        removeResData.heightHint = 25;
        this.removeRes.setLayoutData((Object)removeResData);
        this.removeRes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (IpkDeployWizardPage.this.selectedIndex > -1) {
                    IpkDeployWizardPage.this.resourceList.remove(IpkDeployWizardPage.this.selectedIndex);
                }
            }
        });
        Composite listGroup = new Composite((Composite)resourceGroup, 0);
        GridLayout listGroupLayout = new GridLayout();
        listGroupLayout.numColumns = 1;
        listGroup.setLayout((Layout)listGroupLayout);
        GridData listLayoutData = new GridData(1808);
        listGroup.setLayoutData((Object)listLayoutData);
        this.resourceList = new List(listGroup, 2564);
        this.resourceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IpkDeployWizardPage.this.resourceList = (List)e.getSource();
                IpkDeployWizardPage.this.selectedIndex = IpkDeployWizardPage.this.resourceList.getSelectionIndex();
                if (IpkDeployWizardPage.this.selectedIndex > -1) {
                    String selectedItem = IpkDeployWizardPage.this.resourceList.getItem(IpkDeployWizardPage.this.selectedIndex);
                    System.out.println("Selected Resource is " + selectedItem);
                }
            }
        });
        GridData resourceListGridData = new GridData(1808);
        resourceListGridData.verticalSpan = 4;
        int listHeight = this.resourceList.getItemHeight() * 10;
        Rectangle trim = this.resourceList.computeTrim(0, 0, 0, listHeight);
        resourceListGridData.heightHint = trim.height;
        this.resourceList.setLayoutData((Object)resourceListGridData);
    }

    private boolean checkPageComplete() {
        boolean isComplete = false;
        if (this.projectNameStr.length() > 0 && this.projectTypeStr.length() > 0 && this.versionStr.length() > 0 && this.descriptionStr.length() > 0 && this.providerStr.length() > 0 && this.iconStr.length() > 0 && this.mainClassStr.length() > 0) {
            isComplete = true;
        }
        this.setPageComplete(isComplete);
        return isComplete;
    }

    public Ipkg getIpkg() {
        Ipkg ipkg = new Ipkg();
        String name = this.projectNameStr;
        ipkg.setName(name);
        ipkg.setIconFilename(this.iconStr);
        ipkg.setMainClass(this.mainClassStr);
        Set<Map.Entry<Object, Object>> classSet = this.classMap.entrySet();
        Iterator<Map.Entry<Object, Object>> classIter = classSet.iterator();
        Control control = new Control();
        control.setMaintainerName(this.providerStr);
        control.setMaintainerEmail(this.providerMailStr);
        control.setVersion(this.versionStr);
        control.setDescription(this.descriptionStr);
        ipkg.setControl(control);
        Properties props = new Properties();
        props.put("Comment", this.descriptionStr);
        props.put("Exec", name);
        props.put("Icon", name);
        props.put("Type", "Application");
        props.put("Name", String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
        ipkg.setDesktop(props);
        return ipkg;
    }

    public boolean finish() {
        return this.checkPageComplete();
    }
}

