/*
 * Decompiled with CFR 0.152.
 */
package de.wartala.eclipse.IpkDeploy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public final class IpkgStringWriter {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String implode(Object[] objs, String sep, String pre, String post) {
        String ret = IpkgStringWriter.implode(objs, sep);
        if (ret != null && ret != "") {
            return String.valueOf(pre) + ret + post;
        }
        return ret;
    }

    public static String implode(Object[] objs, String sep) {
        if (objs == null) {
            return null;
        }
        int sz = objs.length;
        if (sz == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer((objs[0].toString().length() + sep.length()) * sz);
        int i = 0;
        while (i < sz) {
            buffer.append(objs[i]);
            if (i != sz - 1) {
                buffer.append(sep);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String implode(Iterator iterator, String sep) {
        StringBuffer buffer = new StringBuffer();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(sep);
        }
        return buffer.toString();
    }

    public static String[] explode(String str) {
        return IpkgStringWriter.explode(str, " ", -1);
    }

    public static String[] explode(String str, String sep) {
        return IpkgStringWriter.explode(str, sep, -1);
    }

    public static String[] explode(String str, String sep, int n) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = null;
        list = n == -1 ? new ArrayList<String>() : new ArrayList(n);
        int idx = 0;
        int prev = 0;
        int sz = sep.length();
        while ((idx = str.indexOf(sep, idx)) != -1) {
            list.add(str.substring(prev, idx));
            prev = idx += sz;
            if (--n == 0) break;
        }
        if (n != 0) {
            list.add(str.substring(prev));
        }
        return list.toArray(new String[0]);
    }

    public static String uncapitalise(String str) {
        return String.valueOf(str.substring(0, 1).toLowerCase()) + str.substring(1);
    }

    public static String capitalise(String str) {
        return "" + Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    public static String replaceStringOnce(String text, String repl, String with) {
        return IpkgStringWriter.replaceString(text, repl, with, 1);
    }

    public static String replaceString(String text, String repl, String with) {
        return IpkgStringWriter.replaceString(text, repl, with, -1);
    }

    public static String replaceString(String text, String repl, String with, int n) {
        int idx = 0;
        while ((idx = text.indexOf(repl)) != -1) {
            text = String.valueOf(text.substring(0, idx)) + with + text.substring(idx + repl.length());
            idx += with.length();
            if (--n == 0) break;
        }
        return text;
    }

    public static String overlayString(String text, String overlay, int start, int end) {
        String pre = text.substring(0, start);
        String post = text.substring(end);
        return String.valueOf(pre) + overlay + post;
    }

    public static String repeat(String str, int n) {
        StringBuffer buffer = new StringBuffer(n * str.length());
        int i = 0;
        while (i < n) {
            buffer.append(str);
            ++i;
        }
        return buffer.toString();
    }

    public static String center(String str, int n) {
        return IpkgStringWriter.center(str, n, " ");
    }

    public static String center(String str, int n, String delim) {
        int sz = str.length();
        int p = n - sz;
        if (p < 1) {
            return str;
        }
        str = IpkgStringWriter.leftPad(str, sz + p / 2, delim);
        str = IpkgStringWriter.rightPad(str, n, delim);
        return str;
    }

    public static String chomp(String str) {
        return IpkgStringWriter.chomp(str, "\n");
    }

    public static String chomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx);
        }
        return str;
    }

    public static String chompLast(String str) {
        return IpkgStringWriter.chompLast(str, "\n");
    }

    public static String chompLast(String str, String sep) {
        if (str.length() == 0) {
            return str;
        }
        String sub = str.substring(str.length() - sep.length());
        if (sep.equals(sub)) {
            return str.substring(0, str.length() - sep.length());
        }
        return str;
    }

    public static String getChomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx == str.length() - sep.length()) {
            return sep;
        }
        if (idx != -1) {
            return str.substring(idx);
        }
        return "";
    }

    public static String prechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(idx + sep.length());
        }
        return str;
    }

    public static String getPrechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx + sep.length());
        }
        return "";
    }

    public static String chop(String str) {
        if ("".equals(str)) {
            return "";
        }
        if (str.length() == 1) {
            return "";
        }
        int lastIdx = str.length() - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String chopNewline(String str) {
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String translate(String target, String repl, String with) {
        StringBuffer buffer = new StringBuffer(target.length());
        char[] chrs = target.toCharArray();
        char[] withChrs = with.toCharArray();
        int sz = chrs.length;
        int withMax = with.length() - 1;
        int i = 0;
        while (i < sz) {
            int idx = repl.indexOf(chrs[i]);
            if (idx != -1) {
                if (idx > withMax) {
                    idx = withMax;
                }
                buffer.append(withChrs[idx]);
            } else {
                buffer.append(chrs[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String escape(String str) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(2 * sz);
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                buffer.append("\\u" + Integer.toHexString(ch));
            } else if (ch > '\u00ff') {
                buffer.append("\\u0" + Integer.toHexString(ch));
            } else if (ch > '\u007f') {
                buffer.append("\\u00" + Integer.toHexString(ch));
            } else if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00" + Integer.toHexString(ch));
                            break;
                        }
                        buffer.append("\\u000" + Integer.toHexString(ch));
                        break;
                    }
                }
            } else {
                switch (ch) {
                    case '\'': {
                        buffer.append('\\');
                        buffer.append('\'');
                        break;
                    }
                    case '\"': {
                        buffer.append('\\');
                        buffer.append('\"');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        buffer.append('\\');
                        break;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String rightPad(String str, int n) {
        return IpkgStringWriter.rightPad(str, n, " ");
    }

    public static String rightPad(String str, int n, String delim) {
        int sz = str.length();
        if ((n = (n - sz) / delim.length()) > 0) {
            str = String.valueOf(str) + IpkgStringWriter.repeat(delim, n);
        }
        return str;
    }

    public static String leftPad(String str, int n) {
        return IpkgStringWriter.leftPad(str, n, " ");
    }

    public static String leftPad(String str, int n, String delim) {
        int sz = str.length();
        if ((n = (n - sz) / delim.length()) > 0) {
            str = String.valueOf(IpkgStringWriter.repeat(delim, n)) + str;
        }
        return str;
    }

    public static String reverse(String str) {
        return new StringBuffer(str).reverse().toString();
    }

    public static String strip(String str) {
        return IpkgStringWriter.strip(str, null);
    }

    public static String strip(String str, String delim) {
        str = IpkgStringWriter.stripStart(str, delim);
        return IpkgStringWriter.stripEnd(str, delim);
    }

    public static String swapCase(String str) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        boolean whitespace = false;
        char ch = '\u0000';
        char tmp = '\u0000';
        int i = 0;
        while (i < sz) {
            ch = str.charAt(i);
            if (Character.isUpperCase(ch)) {
                tmp = Character.toLowerCase(ch);
            } else if (Character.isTitleCase(ch)) {
                tmp = Character.toLowerCase(ch);
            } else if (Character.isLowerCase(ch)) {
                tmp = whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch);
            }
            buffer.append(tmp);
            whitespace = Character.isWhitespace(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static int indexOfAny(String str, String[] strs) {
        int sz = strs.length;
        int ret = str.length();
        int tmp = 0;
        int i = 0;
        while (i < sz) {
            tmp = str.indexOf(strs[i]);
            if (tmp < ret) {
                ret = tmp;
            }
            ++i;
        }
        return ret == str.length() ? -1 : ret;
    }

    public static int lastIndexOfAny(String str, String[] strs) {
        int sz = strs.length;
        int ret = -1;
        int tmp = 0;
        int i = 0;
        while (i < sz) {
            tmp = str.lastIndexOf(strs[i]);
            if (tmp > ret) {
                ret = tmp;
            }
            ++i;
        }
        return ret;
    }

    public static String stripEnd(String str, String ch) {
        int end = str.length();
        if (ch == null) {
            while (Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            char chr = ch.charAt(0);
            while (str.charAt(end - 1) == chr) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String stripStart(String str, String ch) {
        int start = 0;
        if (ch == null) {
            while (Character.isWhitespace(str.charAt(start))) {
                ++start;
            }
        } else {
            char chr = ch.charAt(0);
            while (str.charAt(start) == chr) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String quoteRegularExpression(String str) {
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        StringBuffer buffer = new StringBuffer(2 * sz);
        int i = 0;
        while (i < sz) {
            switch (chrs[i]) {
                case '$': 
                case '*': 
                case '+': 
                case '.': 
                case '/': 
                case '?': 
                case '[': 
                case ']': 
                case '^': {
                    buffer.append("\\");
                }
            }
            buffer.append(chrs[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static String capitaliseAllWords(String str) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        boolean space = true;
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
            } else if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String wordWrap(String str) {
        return IpkgStringWriter.wordWrap(str, 80, "\n", "-");
    }

    public static String wordWrap(String str, int width) {
        return IpkgStringWriter.wordWrap(str, width, "\n", "-");
    }

    public static String wordWrap(String str, int width, String delim, String split) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz / ++width * delim.length() + sz);
        width -= delim.length();
        int idx = -1;
        String substr = null;
        int i = 0;
        while (i < sz) {
            if (i > sz - width) {
                buffer.append(str.substring(i));
                break;
            }
            substr = str.substring(i, i + width);
            idx = substr.indexOf(delim);
            if (idx != -1) {
                buffer.append(substr.substring(0, idx));
                buffer.append(delim);
                i -= width - idx - delim.length();
                if (Character.isWhitespace(substr.charAt(idx + 1))) {
                    ++i;
                }
            } else {
                idx = -1;
                char[] chrs = substr.toCharArray();
                int j = width;
                while (j > 0) {
                    if (Character.isWhitespace(chrs[j - 1])) {
                        idx = j;
                        break;
                    }
                    --j;
                }
                if (idx == -1) {
                    j = width;
                    while (j > 0) {
                        if (chrs[j - 1] == '-') {
                            idx = j;
                            break;
                        }
                        --j;
                    }
                    if (idx == -1) {
                        buffer.append(substr);
                        buffer.append(delim);
                    } else {
                        if (idx != width) {
                            ++idx;
                        }
                        buffer.append(substr.substring(0, idx));
                        buffer.append(delim);
                        i -= width - idx;
                    }
                } else {
                    buffer.append(substr.substring(0, idx));
                    buffer.append(IpkgStringWriter.repeat(" ", width - idx));
                    buffer.append(delim);
                    i -= width - idx;
                }
            }
            i += width;
        }
        return buffer.toString();
    }

    public static String getNestedString(String str, String tag) {
        return IpkgStringWriter.getNestedString(str, tag, tag);
    }

    public static String getNestedString(String str, String open, String close) {
        int end;
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return "";
    }

    public static int countMatches(String str, String sub) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isWord(String str) {
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetter(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLine(String str) {
        boolean ch = false;
        char[] chrs = str.toCharArray();
        int sz = chrs.length - 1;
        int i = 0;
        while (i < sz - 2) {
            if (!Character.isLetterOrDigit(chrs[i]) && !Character.isWhitespace(chrs[i])) {
                return false;
            }
            ++i;
        }
        if (!Character.isLetterOrDigit(chrs[sz - 1]) && !Character.isWhitespace(chrs[sz - 1])) {
            if (chrs[sz - 1] != '\r') {
                return false;
            }
            if (chrs[sz] != '\n') {
                return false;
            }
        }
        return Character.isLetterOrDigit(chrs[sz]) || Character.isWhitespace(chrs[sz]) || chrs[sz] == '\n';
    }

    public static String defaultString(String str) {
        return IpkgStringWriter.defaultString(str, "");
    }

    public static String defaultString(String str, String def) {
        return str == null ? def : str;
    }

    public static String upperCase(String str) {
        return str.toUpperCase();
    }

    public static String lowerCase(String str) {
        return str.toLowerCase();
    }

    public static String trim(String str) {
        return str.trim();
    }

    public static String substring(String str, int start) {
        return IpkgStringWriter.substring(str, start, -1);
    }

    public static String substring(String str, int start, int end) {
        if (end == -1) {
            return str.substring(start);
        }
        return str.substring(start, end);
    }

    public static String random(int count) {
        return IpkgStringWriter.random(count, false, false);
    }

    public static String randomAscii(int count) {
        return IpkgStringWriter.random(count, 32, 127, false, false);
    }

    public static String randomAlphabetic(int count) {
        return IpkgStringWriter.random(count, true, false);
    }

    public static String randomAlphanumeric(int count) {
        return IpkgStringWriter.random(count, true, true);
    }

    public static String randomNumeric(int count) {
        return IpkgStringWriter.random(count, false, true);
    }

    public static String random(int count, boolean letters, boolean numbers) {
        return IpkgStringWriter.random(count, 0, 0, letters, numbers);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return IpkgStringWriter.random(count, start, end, letters, numbers, null);
    }

    /*
     * Unable to fully structure code
     */
    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] set) {
        if (start == 0 && end == 0) {
            end = 122;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = 0x7FFFFFFF;
            }
        }
        rnd = new Random();
        buffer = new StringBuffer();
        gap = end - start;
        if (true) ** GOTO lbl16
        do {
            ch = set == null ? (char)(rnd.nextInt(gap) + start) : set[rnd.nextInt(gap) + start];
            if (letters != false && numbers != false && Character.isLetterOrDigit(ch) != false || letters != false && Character.isLetter(ch) != false || numbers != false && Character.isDigit(ch) != false || !letters && !numbers) {
                buffer.append(ch);
            }
lbl16:
            // 4 sources

            v0 = ++count;
            --count;
        } while (v0 != 0);
        return buffer.toString();
    }

    public static String random(int count, String set) {
        return IpkgStringWriter.random(count, set.toCharArray());
    }

    public static String random(int count, char[] set) {
        return IpkgStringWriter.random(count, 0, set.length - 1, false, false, set);
    }

    public static String interpolate(String text, Map map) {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String value = map.get(key).toString();
            text = IpkgStringWriter.replaceString(text, "${" + key + "}", value);
            if (key.indexOf(" ") != -1) continue;
            text = IpkgStringWriter.replaceString(text, "$" + key, value);
        }
        return text;
    }
}

