package de.wartala.eclipse.IpkDeploy;

/**
 * Encapsulate the IPK control data structure 
 * @author Ramon Wartala
 */
public class Control {
	static private final int K = 1024;
	static private final int M = K * K;
	static private final int G = K * M;
	
	private String packageName;
  private String maintainerName;
  private String description;
  private String maintainerEmail;
  private String section = "java";
  private String version;
	private String architecture = "arm";
	private long size;

	public Control() {
	    super();
	}
	
	/**
	 * Get the filename property
	 *
	 * @return String property
	 */
	public String getFilename() {
		return "./" + this.packageName + "_" + this.version + "_" +
	           this.architecture + ".ipk";
	}
	
	/**
	 * Get the packageName property
	 *
	 * @return String property
	 */
	public String getPackageName() {
		return this.packageName;
	}

	/**
	 * Set the packageName property
	 *
	 * @param packageName String property
	 */
	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}


	/**
	 * Get the maintainerEmail property
	 *
	 * @return String property
	 */
	public String getMaintainerEmail() {
		return this.maintainerEmail;
	}
	
	/**
	 * Set the maintainerEmail property
	 *
	 * @param maintainerEmail String property
	 */
	public void setMaintainerEmail(String maintainerEmail) {
		this.maintainerEmail = maintainerEmail;
	}
	
	/**
	 * Get the architecture property
	 *
	 * @return String property
	 */
	public String getArchitecture() {
		return this.architecture;
	}

	/**
	 * Set the architecture property
	 *
	 * @param architecture String property
	 */
	public void setArchitecture(String architecture) {
		this.architecture = architecture;
	}
	
	/**
	 * Get the version property
	 *
	 * @return String property
	 */
	public String getVersion() {
		return this.version;
	}
	
	/**
	 * Set the version property
	 *
	 * @param version String property
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * Get the maintainerName property
	 *
	 * @return String property
	 */
	public String getMaintainerName() {
		return this.maintainerName;
	}
	
	/**
	 * Set the maintainerName property
	 *
	 * @param maintainerName String property
	 */
	public void setMaintainerName(String maintainerName) {
		this.maintainerName = maintainerName;
	}
	
	/**
	 * Get the section property
	 *
	 * @return String property
	 */
	public String getSection() {
		return this.section;
	}

	/**
	 * Set the section property
	 *
	 * @param section String property
	 */
	public void setSection(String section) {
		this.section = section;
	}

	/**
	 * Get the description property
	 *
	 * @return String property
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * Set the description property
	 *
	 * @param description String property
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Get the size property
	 *
	 * @return long property
	 */
	public long getSize() {
		return this.size;
	}
	
	/**
	 * Get the size in k etc.
	 */
	public String getSizeAsString() {
		if (size / G > 0) {
	  	return String.valueOf(size / G) + "G";
	  } else if (size / M > 0) {
	  	return String.valueOf(size / M) + "M";
	  } else if (size / K > 0) {
	    return String.valueOf(size / K) + "k";
	  } else {
	  	return String.valueOf(size);
	  }
	}
	
	/**
	 * Set the size property
	 *
	 * @param size long property
	 */
	public void setSize(long size) {
		this.size = size;
	}
}

