package de.wartala.eclipse.IpkDeploy;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.ui.plugin.AbstractUIPlugin;

import org.eclipse.ui.PlatformUI;
import org.eclipse.jface.dialogs.MessageDialog;


/**
 * The main plugin class to be used in the desktop.
 */
public class IpkDeployPlugin extends AbstractUIPlugin {
	
	// The shared instance.
	private static IpkDeployPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public IpkDeployPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin= this;
	}


	/**
	 * Returns the shared instance.
	 */
	public static IpkDeployPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	public static ImageDescriptor getImageDescriptor(String name) {
		try {
			URL url= new URL(IpkDeployPlugin.getDefault().getDescriptor().getInstallURL(), name);
			return ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}


	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}


	public static void log(String message) {
		log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, message, null));
	}


	public static void log(Throwable e) {
		log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, "Internal Error", e));
	}
}
