package de.wartala.eclipse.IpkDeploy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/**
 * Encapsulate the whole IPK data structure 
 * 
 * @author Ramon Wartala
 */
public class Ipkg {
	private String iconFilename;
	private Control control;
	private Properties desktop;
	private String name;
	private String mainClass;
	private List classes;
	
	public Ipkg() {
		super();
	}
	
	/**
	 * Method addClass. Add class or JAR files to the package.
	 * @param classname Name of the class or JAR file.
	 */
	public void addClass(String classname) {
		if(classes == null) {
			classes = new ArrayList();
		}
		classes.add(classname);
	}
	
	/**
	 * Method iterateClasses.
	 * @return Iterator
	 */
	public Iterator iterateClasses() {
    if(classes == null) {
        classes = new ArrayList();
    }
    return classes.iterator();
	}
	
	/**
	 * Method setClasses.
	 * @param classes
	 */
	public void setClasses(List classes) {
	  this.classes = classes;
	}
	
	/**
	 * Method removeClass.
	 * @param classname
	 */
	public void removeClass(String classname) {
    if(classes == null) {
        return;
    }
    this.classes.remove(classname);
	}
	
	/**
	 * Get the iconFilename property
	 *
	 * @return String property
	 */
	public String getIconFilename() {
		return this.iconFilename;
	}
	
	/**
	 * Set the iconFilename property
	 *
	 * @param iconFilename String property
	 */
	public void setIconFilename(String iconFilename) {
		this.iconFilename = iconFilename;
	}
	
	
	/**
	 * Get the mainClass property
	 *
	 * @return String property
	 */
	public String getMainClass() {
		return this.mainClass;
	}
	
	/**
	 * Set the mainClass property
	 *
	 * @param mainClass String property
	 */
	public void setMainClass(String mainClass) {
		this.mainClass = mainClass;
	}
	
	/**
	 * Get the name property
	 *
	 * @return String property
	 */
	public String getName() {
		return this.name;
	}
	
	/**
	 * Set the name property
	 *
	 * @param name String property
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	
	/**
	 * Get the control property
	 *
	 * @return Control property
	 */
	public Control getControl() {
		return this.control;
	}
	
	/**
	 * Set the control property
	 *
	 * @param control Control property
	 */
	public void setControl(Control control) {
		this.control = control;
	}
	
	
	/**
	 * Get the desktop property
	 *
	 * @return Properties property
	 */
	public Properties getDesktop() {
		return this.desktop;
	}
	
	/**
	 * Set the desktop property
	 *
	 * @param desktop Properties property
	 */
	public void setDesktop(Properties desktop) {
		this.desktop = desktop;
	}
}

