package de.wartala.eclipse.IpkDeploy;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;

import java.util.Properties;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;

import com.ice.tar.TarEntry;
import com.ice.tar.TarOutputStream;

/** 
 * A class that knows how to read in and write out Ipkgs
 * it currently assumes a certain standard for the naming 
 * conventions. Also assumes that there is only one script
 * etc. Trying to be too generic will just get silly. 
 *
 * @author Ramon Wartala
 */

public class IpkgOutput {

	public IpkgOutput() {
		super();
	}
	
	/**
	 * Method write. Write the IPK data structure to OutputStream.
	 * @param ipkg Instance of Ipkg class.
	 * @param out OutputStream
	 * @throws IOException
	 */
	public void write(Ipkg ipkg, OutputStream out) throws IOException {
	    String name = ipkg.getName();
	    ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
	
	    TarGzOutputStream tgz = new TarGzOutputStream( baos1 );
	    tgz.setDebug(true);
	    
	    // write desktop file
	    TarEntry entry = new TarEntry("./home/QtPalmtop/apps/Jeode/"+name+".desktop");
	    tgz.putNextEntry(entry);
	    writeDesktop(tgz, ipkg);
	    tgz.closeEntry();
	
	    // write bin script
	    entry = new TarEntry("./home/QtPalmtop/bin/"+name);
	    tgz.putNextEntry(entry);
	    writeScript(tgz, ipkg);
	    tgz.closeEntry();
	
	    // write image out. to begin with, just copy 
	    // png file straight in
	    entry = new TarEntry("./home/QtPalmtop/pics/"+name+".png");
	    File file = new File(ipkg.getIconFilename());
	    entry.setSize(file.length());
	    tgz.putNextEntry(entry);
	    writeFile(tgz, file);
	    tgz.closeEntry();
	
	    // output all classes
	    ClassConstantsReflector ccr = new ClassConstantsReflector();
	    Iterator iterator = ipkg.iterateClasses();
	    while(iterator.hasNext()) {
        String filename = (String)iterator.next();
        String classname = null;
        if(filename.endsWith(".class") || filename.endsWith(".CLASS")) {
        	classname = ccr.getFullyQualifiedName(filename)+".class";
        } else {
        	//classname = IpkgStringWriter.getChomp(filename, System.getProperty("file.separator"));
        	classname = filename.substring(
        		filename.lastIndexOf(System.getProperty("file.separator"))+1,
        		filename.length());
        }
        entry = new TarEntry("./home/QtPalmtop/java/"+classname);
        file = new File(filename);
        entry.setSize(file.length());
        tgz.putNextEntry(entry);
        writeFile(tgz, file);
        tgz.closeEntry();
	    }
	
	    // data tgz is finished with
	    tgz.finish();
	    tgz.close();
			tgz = null;
				
	    // set size in control
	    ipkg.getControl().setSize(baos1.size());
	
	    // push Control through controlTos
	    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
	
	    tgz = new TarGzOutputStream( baos2 );
	
	    entry = new TarEntry("./control");
	    tgz.putNextEntry(entry);
	    writeControl(tgz, ipkg);
	    tgz.closeEntry();
	
	    tgz.finish();
	    tgz.close();
	
	    tgz = new TarGzOutputStream( out );
	
	    TarEntry dataEntry = new TarEntry("./data.tar.gz");
	    tgz.putNextEntry(dataEntry);
	    tgz.write( baos1.toByteArray() );
	    tgz.closeEntry();
	
	    TarEntry ctrlEntry = new TarEntry("./control.tar.gz");
	    tgz.putNextEntry(ctrlEntry);
	    tgz.write( baos2.toByteArray() );
	    tgz.closeEntry();
	
	    tgz.finish();
	    tgz.close();
	}
	
	
	/**
	 * Method writeDesktop. Write out the [Desktop Entry] entries.
	 * @param out OutputStream
	 * @param ipkg Instance of Ipkg class.
	 * @throws IOException
	 */
	private void writeDesktop(OutputStream out, Ipkg ipkg) throws IOException {
	    StringBuffer buffer = new StringBuffer();
	    buffer.append("[Desktop Entry]\n");
	    	
	    Properties props = ipkg.getDesktop();
	    Iterator iterator = props.keySet().iterator();
	    while(iterator.hasNext()) {
	    Object key = iterator.next();
	    Object value = props.get(key);
	    buffer.append(key.toString());
	    buffer.append("=");
	    buffer.append(value.toString());
	    buffer.append("\n"); 
	    }
	    out.write(buffer.toString().getBytes());
	   	//System.out.println(buffer.toString());
	}
	
	/**
	 * Method writeScript. Write the start script out.
	 * @param out
	 * @param ipkg Instance of Ipkg class.
	 * @throws IOException
	 */
	private void writeScript(OutputStream out, Ipkg ipkg) throws IOException {
    StringBuffer buffer = new StringBuffer();
    buffer.append(". /home/QtPalmtop/bin/installdir.sh");
    buffer.append("\n$QPEDIR/bin/evm -XappName=");
    buffer.append(ipkg.getName());
    
    Iterator iter = ipkg.iterateClasses();
    while(iter.hasNext()) {
    	buffer.append(" -cp $INSTALLDIR/java/");
    	String classname = (String) iter.next();
    	classname = classname.substring(
       		classname.lastIndexOf(
        		System.getProperty("file.separator")
        	)+1,
        	classname.length()
        ); 
    	buffer.append(classname);
    }
    
    buffer.append(" ");
    buffer.append(ipkg.getMainClass());
    buffer.append(" .");
    out.write(buffer.toString().getBytes());
    //System.out.println(buffer.toString());
	}
	
	/**
	 * Method writeFile. Write .class and JAR files to the Ipkg package.
	 * @param out OutputStream
	 * @param file JAR or class file.
	 * @throws IOException
	 */
	private void writeFile(OutputStream out, File file) throws IOException {
    FileInputStream fis = new FileInputStream(file);
    IpkgStreamWriter.pushStream(fis, out);
    fis.close();
	}
	
	/**
	 * Method writeControl. Write out the control file.
	 * @param out OutputStream
	 * @param ipkg Instance of Ipkg class.
	 * @throws IOException
	 */
	private void writeControl(OutputStream out, Ipkg ipkg) throws IOException {
    Control control = ipkg.getControl();
    StringBuffer buffer = new StringBuffer();
    buffer.append("Package: ");
    buffer.append(control.getPackageName());
    buffer.append("\nInstalled size: ");
    buffer.append(control.getSizeAsString());
    buffer.append("\nFilename: ");
    buffer.append(control.getFilename());
    buffer.append("\nSection: ");
    buffer.append(control.getSection());
    buffer.append("\nMaintainer: ");
    buffer.append(control.getMaintainerName());
    buffer.append(" <");
    buffer.append(control.getMaintainerEmail());
    buffer.append(">\nArchitecture: ");
    buffer.append(control.getArchitecture());
    buffer.append("\nVersion: ");
    buffer.append(control.getVersion());
    buffer.append("\nDescription: ");
    buffer.append(control.getDescription());
    out.write(buffer.toString().getBytes());
    //System.out.println(buffer.toString());  
	}
}
	
