using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Security.Cryptography;
using System.Runtime.InteropServices;

namespace Asymmetric
{
	// Aus der Online-Hilfe, MsgBox in C# verwenden
	public class LibWrap 
	{
		// Declare managed prototypes for unmanaged functions.
		[ DllImport( "User32.dll", EntryPoint="MessageBox", 
			  CharSet=CharSet.Auto )]
		public static extern int MsgBox( int hWnd, String text, String caption, 
			uint type );
		// Causes incorrect output in the message window.
		[ DllImport( "User32.dll", EntryPoint="MessageBoxW", 
			  CharSet=CharSet.Ansi )]
		public static extern int MsgBox2( int hWnd, String text, 
			String caption, uint type );
		// Causes an exception to be thrown. EntryPoint, CharSet, and 
		// ExactSpelling object fields are mismatched.
		[ DllImport( "User32.dll", EntryPoint="MessageBox", 
			  CharSet=CharSet.Ansi, ExactSpelling=true )]
		public static extern int MsgBox3( int hWnd, String text, 
			String caption, uint type );
	}

	/// <summary>
	/// Zusammendfassende Beschreibung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
#region Declarations
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button btnCreateKeyPair;
		private System.Windows.Forms.Button btnSavePrivate;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Button btnLoadFile;
		private System.Windows.Forms.Button btnLoadPublicKey;
		private System.Windows.Forms.Button btnEncryptAndSave;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Button btnLoadEncryptedFile;
		private System.Windows.Forms.Button btnLoadPrivateKey;
		private System.Windows.Forms.Button btnDecryptAndSave;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label11;

		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;

		private string FileName, CryptFileName, PublicKeyName, PrivateKeyName, SaveFileName;

#endregion
		private System.Windows.Forms.TextBox tbPublicKey;
		private System.Windows.Forms.TextBox tbPrivateKey;

		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();
			FileName = CryptFileName = PublicKeyName = PrivateKeyName = SaveFileName = String.Empty;
			//
			// TODO: Fgen Sie den Konstruktorcode nach dem Aufruf von InitializeComponent hinzu
			//
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.tbPublicKey = new System.Windows.Forms.TextBox();
			this.btnCreateKeyPair = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label3 = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.label4 = new System.Windows.Forms.Label();
			this.btnSavePrivate = new System.Windows.Forms.Button();
			this.label2 = new System.Windows.Forms.Label();
			this.tbPrivateKey = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.btnLoadFile = new System.Windows.Forms.Button();
			this.btnLoadPublicKey = new System.Windows.Forms.Button();
			this.btnEncryptAndSave = new System.Windows.Forms.Button();
			this.label6 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.btnLoadEncryptedFile = new System.Windows.Forms.Button();
			this.btnLoadPrivateKey = new System.Windows.Forms.Button();
			this.btnDecryptAndSave = new System.Windows.Forms.Button();
			this.label9 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(192, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Ausgabe des ffentlichen Schlssels:";
			// 
			// tbPublicKey
			// 
			this.tbPublicKey.Location = new System.Drawing.Point(19, 32);
			this.tbPublicKey.Multiline = true;
			this.tbPublicKey.Name = "tbPublicKey";
			this.tbPublicKey.Size = new System.Drawing.Size(264, 96);
			this.tbPublicKey.TabIndex = 1;
			this.tbPublicKey.Text = "";
			// 
			// btnCreateKeyPair
			// 
			this.btnCreateKeyPair.Location = new System.Drawing.Point(19, 286);
			this.btnCreateKeyPair.Name = "btnCreateKeyPair";
			this.btnCreateKeyPair.Size = new System.Drawing.Size(128, 24);
			this.btnCreateKeyPair.TabIndex = 2;
			this.btnCreateKeyPair.Text = "Schlssel erzeugen";
			this.btnCreateKeyPair.Click += new System.EventHandler(this.CreateKeyPair_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.label8,
																					this.label7,
																					this.label6,
																					this.btnEncryptAndSave,
																					this.btnLoadPublicKey,
																					this.btnLoadFile,
																					this.label3});
			this.groupBox1.Location = new System.Drawing.Point(296, 16);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(448, 168);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Eine Datei verschlsseln";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 19);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(432, 64);
			this.label3.TabIndex = 0;
			this.label3.Text = @"Dieser Teil ldt eine unverschlsselte Datei, erzeugt dazu einen symmetrischen Schlssel, verschlsselt die Datei damit und nutzt anschlieend den ffentlichen Schlssel des asymmetrischen Algorithmus, um den Schlssel (!) zu verschlsseln. Dann wird der Schlssel der Datei vorangestellt und die Datei bertragen.";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.label11,
																					this.label10,
																					this.label9,
																					this.btnDecryptAndSave,
																					this.btnLoadPrivateKey,
																					this.btnLoadEncryptedFile,
																					this.label4});
			this.groupBox2.Location = new System.Drawing.Point(296, 200);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(448, 160);
			this.groupBox2.TabIndex = 4;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Eine Datei entschlsseln";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(432, 80);
			this.label4.TabIndex = 0;
			this.label4.Text = @"Der Empfnger muss ber den privaten Teil des asymmetrischen Schlssels verfgen. Zuerst extrahiert das Programm den verschlsselten symmetrischen Schlssel aus der empfangenen kodierten Datei. Dann wendet es den asymmetrischen privaten Schlssel an und erhlt so den symmetrischen Schlssel. Dieser wird dann benutzt, um die Datei selbst zu entschlsseln.";
			// 
			// btnSavePrivate
			// 
			this.btnSavePrivate.Location = new System.Drawing.Point(152, 286);
			this.btnSavePrivate.Name = "btnSavePrivate";
			this.btnSavePrivate.Size = new System.Drawing.Size(128, 24);
			this.btnSavePrivate.TabIndex = 5;
			this.btnSavePrivate.Text = "Schlssel speichern";
			this.btnSavePrivate.Click += new System.EventHandler(this.btnSavePrivate_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 317);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(272, 40);
			this.label2.TabIndex = 6;
			this.label2.Text = "(c) 2003 by Jrg Krause. Demonstration eines Verschlsselungsprogramms mit RSA/Ri" +
				"jndael-Kombination (1024 Bit)";
			// 
			// tbPrivateKey
			// 
			this.tbPrivateKey.Location = new System.Drawing.Point(19, 152);
			this.tbPrivateKey.Multiline = true;
			this.tbPrivateKey.Name = "tbPrivateKey";
			this.tbPrivateKey.Size = new System.Drawing.Size(264, 128);
			this.tbPrivateKey.TabIndex = 7;
			this.tbPrivateKey.Text = "";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 136);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(256, 16);
			this.label5.TabIndex = 8;
			this.label5.Text = "Ausgabe des gesamten Schlssels (ff. und priv.):";
			// 
			// btnLoadFile
			// 
			this.btnLoadFile.Location = new System.Drawing.Point(8, 136);
			this.btnLoadFile.Name = "btnLoadFile";
			this.btnLoadFile.Size = new System.Drawing.Size(104, 23);
			this.btnLoadFile.TabIndex = 1;
			this.btnLoadFile.Text = "Datei auswhlen";
			this.btnLoadFile.Click += new System.EventHandler(this.btnLoadFile_Click);
			// 
			// btnLoadPublicKey
			// 
			this.btnLoadPublicKey.Location = new System.Drawing.Point(112, 136);
			this.btnLoadPublicKey.Name = "btnLoadPublicKey";
			this.btnLoadPublicKey.Size = new System.Drawing.Size(176, 23);
			this.btnLoadPublicKey.TabIndex = 2;
			this.btnLoadPublicKey.Text = "ffentlichen Schlssel whlen";
			this.btnLoadPublicKey.Click += new System.EventHandler(this.btnLoadPublicKey_Click);
			// 
			// btnEncryptAndSave
			// 
			this.btnEncryptAndSave.Location = new System.Drawing.Point(288, 136);
			this.btnEncryptAndSave.Name = "btnEncryptAndSave";
			this.btnEncryptAndSave.Size = new System.Drawing.Size(152, 23);
			this.btnEncryptAndSave.TabIndex = 3;
			this.btnEncryptAndSave.Text = "Verschlsseln && Speichern";
			this.btnEncryptAndSave.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnEncryptAndSave.Click += new System.EventHandler(this.btnEncryptAndSave_Click);
			// 
			// label6
			// 
			this.label6.Font = new System.Drawing.Font("Verdana", 20.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label6.Location = new System.Drawing.Point(48, 96);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(40, 32);
			this.label6.TabIndex = 4;
			this.label6.Text = "1.";
			// 
			// label7
			// 
			this.label7.Font = new System.Drawing.Font("Verdana", 20.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label7.Location = new System.Drawing.Point(184, 96);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(40, 32);
			this.label7.TabIndex = 5;
			this.label7.Text = "2.";
			// 
			// label8
			// 
			this.label8.Font = new System.Drawing.Font("Verdana", 20.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label8.Location = new System.Drawing.Point(344, 96);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(40, 32);
			this.label8.TabIndex = 6;
			this.label8.Text = "3.";
			// 
			// btnLoadEncryptedFile
			// 
			this.btnLoadEncryptedFile.Location = new System.Drawing.Point(8, 128);
			this.btnLoadEncryptedFile.Name = "btnLoadEncryptedFile";
			this.btnLoadEncryptedFile.Size = new System.Drawing.Size(112, 24);
			this.btnLoadEncryptedFile.TabIndex = 1;
			this.btnLoadEncryptedFile.Text = "Datei auswhlen";
			this.btnLoadEncryptedFile.Click += new System.EventHandler(this.btnLoadEncryptedFile_Click);
			// 
			// btnLoadPrivateKey
			// 
			this.btnLoadPrivateKey.Location = new System.Drawing.Point(120, 128);
			this.btnLoadPrivateKey.Name = "btnLoadPrivateKey";
			this.btnLoadPrivateKey.Size = new System.Drawing.Size(160, 24);
			this.btnLoadPrivateKey.TabIndex = 2;
			this.btnLoadPrivateKey.Text = "Privaten Schlssel whlen";
			this.btnLoadPrivateKey.Click += new System.EventHandler(this.btnLoadPrivateKey_Click);
			// 
			// btnDecryptAndSave
			// 
			this.btnDecryptAndSave.Location = new System.Drawing.Point(280, 128);
			this.btnDecryptAndSave.Name = "btnDecryptAndSave";
			this.btnDecryptAndSave.Size = new System.Drawing.Size(160, 24);
			this.btnDecryptAndSave.TabIndex = 3;
			this.btnDecryptAndSave.Text = "Entschlsseln && Speichern";
			this.btnDecryptAndSave.Click += new System.EventHandler(this.btnDecryptAndSave_Click);
			// 
			// label9
			// 
			this.label9.Font = new System.Drawing.Font("Verdana", 20F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label9.Location = new System.Drawing.Point(52, 93);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(40, 32);
			this.label9.TabIndex = 4;
			this.label9.Text = "1.";
			// 
			// label10
			// 
			this.label10.Font = new System.Drawing.Font("Verdana", 20F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label10.Location = new System.Drawing.Point(189, 94);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(40, 32);
			this.label10.TabIndex = 5;
			this.label10.Text = "2.";
			// 
			// label11
			// 
			this.label11.Font = new System.Drawing.Font("Verdana", 20F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label11.Location = new System.Drawing.Point(344, 96);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(40, 32);
			this.label11.TabIndex = 6;
			this.label11.Text = "3.";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(752, 365);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label5,
																		  this.tbPrivateKey,
																		  this.label2,
																		  this.btnSavePrivate,
																		  this.groupBox2,
																		  this.groupBox1,
																		  this.btnCreateKeyPair,
																		  this.tbPublicKey,
																		  this.label1});
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "Form1";
			this.Text = "RSAServiceProvider";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void CreateKeyPair_Click(object sender, System.EventArgs e)
		{
			RSACryptoServiceProvider rcp = new RSACryptoServiceProvider();
			this.tbPublicKey.Text = rcp.ToXmlString(false).Replace(">", ">\r\n");
			this.tbPrivateKey.Text = rcp.ToXmlString(true).Replace(">", ">\r\n");
		}

		private void btnLoadFile_Click(object sender, System.EventArgs e)
		{
			openFileDialog1 = new OpenFileDialog();
			openFileDialog1.InitialDirectory = @"c:\";
			openFileDialog1.Filter = "Alle Dateien (*.*)|*.*";
			openFileDialog1.FilterIndex = 0;
			openFileDialog1.Multiselect = false;
			openFileDialog1.RestoreDirectory = true;
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				FileName = openFileDialog1.FileName;
			}
		}

		private void btnLoadPublicKey_Click(object sender, System.EventArgs e)
		{
			openFileDialog1 = new OpenFileDialog();
			openFileDialog1.InitialDirectory = @"c:\";
			openFileDialog1.Filter = "ffentlicher Schlssel (*.public.key)|*.public.key|Alle Dateien (*.*)|*.*";
			openFileDialog1.FilterIndex = 0;
			openFileDialog1.Multiselect = false;
			openFileDialog1.RestoreDirectory = true;
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				PublicKeyName = openFileDialog1.FileName;
			}
		}

		private void btnLoadPrivateKey_Click(object sender, System.EventArgs e)
		{
			openFileDialog1 = new OpenFileDialog();
			openFileDialog1.InitialDirectory = @"c:\";
			openFileDialog1.Filter = "Privater Schlssel (*.private.key)|*.private.key|Alle Dateien (*.*)|*.*";
			openFileDialog1.FilterIndex = 0;
			openFileDialog1.Multiselect = false;
			openFileDialog1.RestoreDirectory = true;
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				PrivateKeyName = openFileDialog1.FileName;
			}		
		}

		private void btnLoadEncryptedFile_Click(object sender, System.EventArgs e)
		{
			openFileDialog1 = new OpenFileDialog();
			openFileDialog1.InitialDirectory = @"c:\";
			openFileDialog1.Filter = "Verschlsselte Dateien (*.crypt)|*.crypt|Alle Dateien (*.*)|*.*";
			openFileDialog1.FilterIndex = 0;
			openFileDialog1.Multiselect = false;
			openFileDialog1.RestoreDirectory = true;
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				CryptFileName = openFileDialog1.FileName;
			}
		}

		private void btnEncryptAndSave_Click(object sender, System.EventArgs e)
		{
			// Nimmt Datei und ffentlichen Schlssel und speichert verschlsselte Datei
			if (FileName.Equals(string.Empty) || PublicKeyName.Equals(string.Empty))
			{
				LibWrap.MsgBox(0, "Fehler: Datei und/oder Schlssel nicht geladen", "Fehler", 0);
			} 
			else 
			{
				// Speicherort festlegen
				saveFileDialog1 = new SaveFileDialog();
				saveFileDialog1.Filter = "Verschlsselte Datei (*.crypt)|*.crypt|Alle Dateien (*.*)|*.*";
				saveFileDialog1.FilterIndex = 0;
				saveFileDialog1.RestoreDirectory = true ;
				// TODO: Achtung! Keine Sicherheitsabfrage implementiert
				if(saveFileDialog1.ShowDialog() == DialogResult.OK)
				{
					SaveFileName = saveFileDialog1.FileName;
				} 
				else 
				{
					SaveFileName = FileName.Substring(0, FileName.LastIndexOf(".")) + ".crypt"; 
				}
				// Verschlsselung vornehmen
				RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
				string publicKey = GetKey(PublicKeyName);							// Der Schlssel aus der Schlsseldatei
				rsa.FromXmlString(publicKey);										// ffentlichen Schlssel setzen
				Rijndael rj = Rijndael.Create();									// Symmetrischer Algorithmus
				FileStream fsLoadFile = File.Open(FileName, FileMode.Open);			// Zu verschlsselnde Datei
				FileStream fsSaveFile = File.Open(SaveFileName, FileMode.Create);	// Speicherort
				byte[] cryptSymmKey = rsa.Encrypt(rj.Key, false);					// Symmetrischen Schlssel verschlsseln
				fsSaveFile.Write(cryptSymmKey, 0, 128);								// Schlssel in Datei schreiben
				fsSaveFile.Write(rj.IV, 0, 16);										// Rijndael-Vektor sichern
				// Nun wird der Ausgabedatenstrom (die Daten) mit dem Rijndael-
				CryptoStream saveContent = new CryptoStream(fsSaveFile, rj.CreateEncryptor(), CryptoStreamMode.Write);
				byte[] fileContent = GetStream(fsLoadFile);
				saveContent.Write(fileContent, 0, fileContent.Length);
				saveContent.FlushFinalBlock();
				saveContent.Close();
				fsLoadFile.Close();
				fsSaveFile.Close();
				LibWrap.MsgBox(0, "Fertig! Datei verschlsselt und gespeichert.", "Hinweis", 0);
			}
		}

		private string GetKey(string FileName)
		{
			StreamReader sr = new StreamReader(File.Open(FileName,FileMode.Open));
			string sPublicKey = sr.ReadToEnd();
			sr.Close();
			return sPublicKey;
		}

		private byte[] GetStream(Stream st)
		{
			byte[] fileContent = null;
			byte[] dummy = null;
			byte[] buffer = new byte[1024];
			int iRead;
			int iLength = 0;
			while ((iRead = st.Read(buffer, 0, 1024)) > 0)
			{
				dummy = new byte[iLength + iRead];
				if (iLength > 0) 
				{
					fileContent.CopyTo(dummy, 0);
				}
				Array.Copy(buffer, 0, dummy, iLength, iRead);
				fileContent = dummy;
				iLength += iRead;
			}
			st.Close();
			return fileContent;
		}

		private void btnSavePrivate_Click(object sender, System.EventArgs e)
		{
			saveFileDialog1 = new SaveFileDialog();
			saveFileDialog1.Filter = "Zwei Schlsseldateien (*.private.key und *.public.key)|*.key|Alle Dateien (*.*)|*.*";
			saveFileDialog1.FilterIndex = 0;
			saveFileDialog1.RestoreDirectory = true ;
			StreamWriter sw;
			if(saveFileDialog1.ShowDialog() == DialogResult.OK)
			{
				sw = new StreamWriter(Path.GetDirectoryName(saveFileDialog1.FileName) + @"\" + Path.GetFileNameWithoutExtension(saveFileDialog1.FileName) + ".public.key");
				sw.Write(this.tbPublicKey.Text);
				sw.Close();
				sw = new StreamWriter(Path.GetDirectoryName(saveFileDialog1.FileName) + @"\" + Path.GetFileNameWithoutExtension(saveFileDialog1.FileName) + ".private.key");
				sw.Write(this.tbPrivateKey.Text);
				sw.Close();
			} 
		}

		private void btnDecryptAndSave_Click(object sender, System.EventArgs e)
		{
			// Nimmt Datei und ffentlichen Schlssel und speichert verschlsselte Datei
			if (CryptFileName.Equals(string.Empty) || PrivateKeyName.Equals(string.Empty))
			{
				LibWrap.MsgBox(0, "Fehler: Datei und/oder Schlssel nicht geladen", "Fehler", 0);
			} 
			else 
			{
				// Speicherort festlegen, Standard-Extension folgt der der crypto-Datei
				saveFileDialog1 = new SaveFileDialog();
				string Extension = Path.GetExtension(CryptFileName.Substring(0, CryptFileName.LastIndexOf(".")));
				if (Extension.Equals(string.Empty))
				{
					Extension = ".*";
				}
				saveFileDialog1.Filter = "Entschlsselte Datei (*" + Extension + ")|*" + Extension + "|Alle Dateien (*.*)|*.*";
				saveFileDialog1.FilterIndex = 0;
				saveFileDialog1.RestoreDirectory = true ;
				// TODO: Achtung! Keine Sicherheitsabfrage implementiert
				if(saveFileDialog1.ShowDialog() == DialogResult.OK)
				{
					SaveFileName = saveFileDialog1.FileName;
				} 
				else 
				{
					SaveFileName = "temp.txt"; 
				}
				try
				{
					// Entschlsselung vornehmen
					byte[] seed = new byte[16];
					RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
					string privateKey = GetKey(PrivateKeyName);
					rsa.FromXmlString(privateKey);										// privaten (!) Schlssel setzen
					Rijndael rj = Rijndael.Create();									// Symmetrischer Algorithmus
					FileStream fsLoadFile = File.Open(CryptFileName, FileMode.Open);	// Zu entschlsselnde Datei
					FileStream fsSaveFile = File.Open(SaveFileName, FileMode.Create);	// Speicherort
					byte[] encryptKey = new byte[128];									// Platz fr den symm. Schlssel
					byte[] IV = new Byte[16];											// Platz fr Rijndael-Vektor
					fsLoadFile.Read(encryptKey, 0, 128);								// Schlssel aus der Datei lesen
					fsLoadFile.Read(IV, 0, 16);											// Vektor aus der Datei lesen
					rj.Key = rsa.Decrypt(encryptKey, false);							// Mit RSA entschlsseln und zuweisen
					rj.IV = IV;
					Stream decryptoStream = new CryptoStream(fsLoadFile, rj.CreateDecryptor(), CryptoStreamMode.Read);
					byte[] fileContent = GetStream(decryptoStream);						// Datei lesen
					fsSaveFile.Write(fileContent, 0, fileContent.Length);				// Ohne Vektor schreiben
					fsSaveFile.Close();
					fsLoadFile.Close();
					LibWrap.MsgBox(0, "Fertig! Datei entschlsselt und gespeichert.", "Hinweis", 0);
				}
				catch (CryptographicException ex)
				{
					LibWrap.MsgBox(0, "Fehler! Dies war der falsche Schlssel.", "Hinweis", 0);
				}
			}		
		}
	}
}
