using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Security.Cryptography;

namespace CryptoProjekt
{
	/// <summary>
	/// Zusammendfassende Beschreibung fr Form1.
	/// </summary>
	public class Hash : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button Quit;
		private System.Windows.Forms.Button Calculate;
		private System.Windows.Forms.TextBox md5Hash;
		private System.Windows.Forms.TreeView ViewFiles;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private void FillTreeViewWithFiles(ref TreeNode tn, string path)
		{
			DirectoryInfo di = new DirectoryInfo(path);
			if (di.GetFiles() != null)
			{
				foreach (FileInfo fi in di.GetFiles())
				{
					tn.Nodes.Add(new TreeNode(fi.Name));
				}
			}
			if (di.GetDirectories() != null)
			{
				foreach (DirectoryInfo dif in di.GetDirectories())
				{
					TreeNode tn2 = new TreeNode(dif.Name);
					FillTreeViewWithFiles(ref tn2, dif.FullName);
					tn.Nodes.Add(tn2);
				}
			}
		}

		public Hash()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();
			string path = @"D:\Inetpub\wwwroot\phpTemplePro";
			TreeNode tn = new TreeNode(path);
			FillTreeViewWithFiles(ref tn, path);
			ViewFiles.Nodes.Add(tn);
			ViewFiles.Visible = true;
			ViewFiles.Refresh();
		}

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.ViewFiles = new System.Windows.Forms.TreeView();
			this.md5Hash = new System.Windows.Forms.TextBox();
			this.Quit = new System.Windows.Forms.Button();
			this.Calculate = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// ViewFiles
			// 
			this.ViewFiles.ImageIndex = -1;
			this.ViewFiles.Location = new System.Drawing.Point(8, 8);
			this.ViewFiles.Name = "ViewFiles";
			this.ViewFiles.SelectedImageIndex = -1;
			this.ViewFiles.Size = new System.Drawing.Size(272, 192);
			this.ViewFiles.TabIndex = 0;
			this.ViewFiles.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.ViewFiles_AfterSelect);
			// 
			// md5Hash
			// 
			this.md5Hash.Location = new System.Drawing.Point(8, 208);
			this.md5Hash.Name = "md5Hash";
			this.md5Hash.Size = new System.Drawing.Size(272, 20);
			this.md5Hash.TabIndex = 1;
			this.md5Hash.Text = "";
			// 
			// Quit
			// 
			this.Quit.Location = new System.Drawing.Point(208, 240);
			this.Quit.Name = "Quit";
			this.Quit.TabIndex = 2;
			this.Quit.Text = "Beenden";
			this.Quit.Click += new System.EventHandler(this.Quit_Click);
			// 
			// Calculate
			// 
			this.Calculate.Location = new System.Drawing.Point(128, 240);
			this.Calculate.Name = "Calculate";
			this.Calculate.TabIndex = 3;
			this.Calculate.Text = "Berechnen";
			this.Calculate.Click += new System.EventHandler(this.Calculate_Click);
			// 
			// Hash
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.Calculate,
																		  this.Quit,
																		  this.md5Hash,
																		  this.ViewFiles});
			this.Name = "Hash";
			this.Text = "MD5 Hashberechnung";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Hash());
		}

		private void Quit_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void ViewFiles_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			this.md5Hash.Text = e.Node.FullPath;
		}

		private void Calculate_Click(object sender, System.EventArgs e)
		{
			String path = this.md5Hash.Text;
			if (File.Exists(path))
			{
				try
				{
					this.md5Hash.Text = String.Empty;
					FileStream fs = new FileStream(path, FileMode.Open);
					MD5 md5 = new MD5CryptoServiceProvider();
					byte[] result = md5.ComputeHash(fs);
					fs.Close();
					for (int i = 0; i < result.Length; i++)
					{
						this.md5Hash.Text += String.Format("{0:X}", result[i]);
					}
				}
				catch (Exception ex)
				{
					this.md5Hash.Text = "Fehler: " + ex.Message;
				}
			}
		}

	}
}
