<cfcomponent>

	<!--- Namen der Datenquelle festlegen --->
	<cfset this.ds = "auktionator">
	<!--- Locale auf Deutsch setzen --->
	<cfset newlocale = SetLocale("German (Standard)")>
	
	<!--- Funktion: getKategorien --->
	<!--- Gibt ein Query-Objekt mit allen Kategorien zurck --->
	<cffunction name="getKategorien" access="remote" hint="Liefert Query von Kategorien" output="no" returntype="query">
		<cfquery datasource="#this.ds#" name="qKategorien">
			SELECT KAT_ID, KAT_NAME
			FROM KATEGORIEN
			ORDER BY KAT_NAME	
		</cfquery>
		<cfreturn qKategorien>	
	</cffunction>
	
	<!--- Funktion: getArtikel --->
	<!--- Gibt ein Query-Objekt mit allen Artikeln einer Kategorie zurck --->
	<cffunction name="getArtikel" access="remote" hint="Liefert Query von Artikeln" output="no" returntype="query">
		<cfargument name="pARTKATID" required="yes" type="numeric">
		<cfquery datasource="#this.ds#" name="qArtikel">
			SELECT ART_ID, ART_NAME
			FROM ARTIKEL
			WHERE ART_KAT_ID = #arguments.pARTKATID#
			ORDER BY ART_NAME
		</cfquery>
		<cfreturn qArtikel>
	</cffunction>

	<!--- Funktion: getArtikelDetailsStruct --->
	<!--- Gibt eine Structure mit Details zu einem Artikel zurck --->
	<cffunction name="getArtikelDetailsStruct" access="remote" hint="Liefert Structure mit Artikeldaten" output="no" returntype="struct">
		<cfargument name="pARTID" required="yes" type="numeric">
		<cfquery datasource="#this.ds#" name="qArtikelDetails">
			SELECT ART_NAME, ART_PREIS, ART_BESCHREIBUNG, ART_ORT, ART_ANBIETER, ART_IMAGE
			FROM ARTIKEL
			WHERE ART_ID = #arguments.pARTID#		
		</cfquery>
		
		<cfscript>
			// Leere Structure anlegen
			stArtikel = StructNew();
			stArtikel.id = arguments.pARTID;
			stArtikel.name = '#qArtikelDetails.ART_NAME#';
			// Preis als Whrung darstellen
			stArtikel.preis = '#LSEuroCurrencyFormat(qArtikelDetails.ART_PREIS)#';
			stArtikel.beschreibung = '#qArtikelDetails.ART_BESCHREIBUNG#';
			stArtikel.ort = '#qArtikelDetails.ART_ORT#';
			stArtikel.anbieter = '#qArtikelDetails.ART_ANBIETER#';
			stArtikel.image = '#qArtikelDetails.ART_IMAGE#';
		</cfscript>
		<cfreturn stArtikel>
	</cffunction>

</cfcomponent>