using System;

namespace Interfaces
{
	/// <summary>
	/// A person
	/// </summary>
	public class CDog:INotifyable
	{
		private string m_strPetName, m_strBreed;
		#region ctors
		public CDog():this("", "")
		{}
		public CDog(string strPetName):this(strPetName, "")
		{}
		public CDog(string strPetName, string strBreed)
		{
			m_strPetName=strPetName;
			m_strBreed=strBreed;
		}

		#endregion
		/// <summary>
		/// Name of the dog
		/// </summary>
		public string Name
		{
			get{return m_strPetName;}
			set{m_strPetName=value;}
		}
		/// <summary>
		/// Type of the dog
		/// </summary>
		public string Breed
		{
			get{return m_strBreed;}
			set{m_strBreed=value;}
		}
		/// <summary>
		/// Is called when a worker makes progress
		/// </summary>
		/// <param name="sender">Worker who has sent the notification</param>
		/// <param name="bytProgress">The percentage of completed work</param>
		/// <returns>The feedback that the dog gives about the work progress</returns>
		EFeedback INotifyable.ReportProgress(CWorker sender, byte bytProgress)
		{      
			Console.WriteLine("{0} , der {1}, wurde benachrichtigt dass {2} " + 
							 "{3} Prozent seiner Arbeit erledigt hat", 
							this.Name, this.Breed, sender.FirstName, bytProgress.ToString());
			if (bytProgress <100)
				return EFeedback.enmNotInterested; //The dog does not care about the work progress
			else	
				return EFeedback.enmGreat; //but in case the work is finally done, it is happy.
		}
		/// <summary>
		/// Is called when a workers status changes
		/// </summary>
		/// <param name="sender">Worker who has sent the notification</param>
		/// <param name="enmStatus">The current status of the worker</param>
		void INotifyable.ReportStatusChange(CWorker sender, EStatus enmStatus)
		{
			if (enmStatus==EStatus.enmIdle)
			{
				Console.WriteLine("{0}, der {1} sagt: Hallo {2}, ich sehe Du bist am faulenzen", this.Name, this.Breed, sender.FirstName);
				Console.WriteLine("Lass uns Gassi gehen!!\n");
			}
			else if (enmStatus==EStatus.enmWorkCompleted)
			{
				Console.WriteLine("{0}, der {1} sagt: Hallo {2}, ich sehe Du bist fertig mit arbeiten", this.Name, this.Breed, sender.FirstName);
				Console.WriteLine("Lass uns Gassi gehen!!\n");
			}
			else 
			{
				Console.WriteLine("{0}, der {1} sagt: Hallo {2}, ich sehe Du hast keine Zeit fr mich\n", this.Name, this.Breed, sender.FirstName);
			}
		}
	}
}

