using System;

namespace Interfaces
{
	/// <summary>
	/// A class that implements this interface is able to be notified in case 
	/// of progress updates or status changes.
	/// </summary>
	public interface INotifyable
	{
		/// <summary>
		/// Notifies a receiver about status changes
		/// </summary>
		/// <param name="sender">The worker who has sent the notification</param>
		/// <param name="enmStatus">The new status of the work</param>
		void ReportStatusChange(CWorker sender, EStatus enmStatus);
		/// <summary>
		/// Notifies a receiver about 
		/// </summary>
		/// <param name="sender">The worker who has sent the notification</param>
		/// <param name="bytPercentComplete">The percentage of completed work</param>
		/// <returns>The "satisfaction level" of the notified object about 
		/// the reported progress</returns>
		EFeedback ReportProgress(CWorker sender, byte bytPercentComplete); 
	}
}
