using System;
using System.Collections;

namespace Interfaces
{
	/// <summary>
	/// Collection of notifyable objects
	/// </summary>
	public class CNotifyableObjCollection:CollectionBase
	{
		public CNotifyableObjCollection()
		{
			//
			// TODO: Add constructor logic here
			//
		}
		/// <summary>
		/// Add an object that supports the INotifyable interface to the collection
		/// </summary>
		/// <param name="obj">The notifyable object that should be added</param>
		/// <returns>The index on which the object has been added</returns>
		public int Add(INotifyable obj)
		{
			return this.InnerList.Add(obj);
			
		}
		/// <summary>
		/// Indexer that returns a reference to the INotifyable interface 
		/// of the object on the given index
		/// </summary>
		public INotifyable this[int index]
		{
			get {return (INotifyable)this.InnerList[index];}
		}
		/// <summary>
		/// Check if a given notifyable object is already contained the collection
		/// </summary>
		/// <param name="obj">The object which si sought</param>
		/// <returns>true: the object is found in the collection. 
		/// false: the object is not yet part of the collection</returns>
		public bool Contains(INotifyable obj)
		{
			return this.InnerList.Contains(obj);
		}
		/// <summary>
		/// Find the position of a notifyable object in the collection
		/// </summary>
		/// <param name="obj">The object that is sought</param>
		/// <returns>The index in the collection</returns>
		public int BinarySearch(INotifyable obj)
		{
			return this.InnerList.BinarySearch(obj);
		}
	}
}
