using System;

namespace Delegates
{
	/// <summary>
	/// A person
	/// </summary>
	public class CDog 
	{
		#region MEMBERS
		private string m_strPetName, m_strBreed;
		#endregion
		#region CONSTRUCTORS
		public CDog():this("", "")
		{}
		public CDog(string strPetName):this(strPetName, "")
		{}
		public CDog(string strPetName, string strBreed)
		{
			m_strPetName=strPetName;
			m_strBreed=strBreed;
		}
		#endregion
		#region PROPERTIES
		/// <summary>
		/// Name of the dog. 
		/// </summary>
		public string Name
		{
			get{return m_strPetName;}
			set{m_strPetName=value;}
		}
		/// <summary>
		/// Type of the dog
		/// </summary>
		public string Breed
		{
			get{return m_strBreed;}
			set{m_strBreed=value;}
		}
		#endregion

		/// <summary>
		/// Is called when a worker makes progress
		/// </summary>
		/// <param name="sender">Worker who has sent the notification</param>
		/// <param name="bytProgress">The percentage of completed work</param>
		/// <returns>The feedback that the dog gives about the work progress</returns>
		public EFeedback ReportProgress(CWorker sender, byte bytProgress)
		{      
			Console.WriteLine("{0} , the {1}, has been notified that {2} has done " + 
							 "{3} percent of his work", 
							this.Name, this.Breed, sender.FirstName, bytProgress.ToString());
			if (bytProgress <100)
				return EFeedback.enmNotInterested; //The dog does not care about the work progress
			else	
				return EFeedback.enmGreat; //but in case the work is finally done, it is happy.
		}
		/// <summary>
		/// Is called when a workers status changes
		/// </summary>
		/// <param name="sender">Worker who has sent the notification</param>
		/// <param name="enmStatus">The current status of the worker</param>
		public void ReportStatusChange(CWorker sender, EStatus enmStatus)
		{
			if (enmStatus==EStatus.enmIdle)
			{
				Console.WriteLine("{0}, the {1} says: Hello {2}, I see that you are lazy", this.Name, this.Breed, sender.FirstName);
				Console.WriteLine("Lets go outside for a walk!!\n");
			}
			else if (enmStatus==EStatus.enmWorkCompleted)
			{
				Console.WriteLine("{0}, the {1} says: Hello {2}, I see that you have finished your work", this.Name, this.Breed, sender.FirstName);
				Console.WriteLine("Lets go outside for a walk!!\n");
			}
			else 
			{
				Console.WriteLine("{0}, the {1} says: Hello {2}, I see that you don't have time for me\n", this.Name, this.Breed, sender.FirstName);
			}
		}
	}
}

