using System;

namespace Delegates
{
	/// <summary>
	/// Delegate for reporting the change of the status the worker is in
	/// </summary>
	public delegate void ReportStatusChangeHandler (CWorker sender, EStatus enmStatus);
	/// <summary>
	/// Delegate for reporting the progress of the work an getting information
	/// about the satisfaction about the work
	/// </summary>
	public delegate EFeedback ReportProgressHandler (CWorker sender, byte bytPercentComplete);
	/// <summary>
	/// A worker, which starts working when he is requested to do so and sends notofications to registred people.
	/// </summary>
	public class CWorker : CPerson
	{
		#region MEMBERS
		private long m_lngLastStartTime;
		private long m_lngLastStopTime;
		private TimeSpan m_tsLastExecutionTime;
		/// <summary>
		/// Current status of the work
		/// </summary>
		private EStatus m_enmStatus;
		/// <summary>
		/// Timer that fires each second as long as work is in progress
		/// </summary>
		private System.Timers.Timer m_timer;
		private const int TIMER_INTERVAL=10000;
        /// <summary>
		/// The current progress of the work (0..100 percent)
		/// </summary>
		private byte m_bytProgress=0;
		#endregion

		#region CONSTRUCTORS
		public CWorker():this("", "")
		{}
		public CWorker(string strFirstName, string strLastName):this(strFirstName, strLastName, DateTime.Today)
		{}
		public CWorker(string strFirstName, string strLastName, DateTime dtDateOfBirth):base(strFirstName, strLastName, dtDateOfBirth)
		{
			m_enmStatus=EStatus.enmIdle; 
			m_timer=new System.Timers.Timer(TIMER_INTERVAL); //A timer that fires all second
			m_timer.AutoReset=true;
			m_timer.Elapsed+=new System.Timers.ElapsedEventHandler(OnTimerElapsed);
		}
		#endregion

		public event ReportProgressHandler progress;
		public event ReportStatusChangeHandler status;

		/// <summary>
		/// Tells the worker to start working
		/// </summary>
		public void StartWork()
		{ 
			m_lngLastStartTime=DateTime.Now.Ticks;
			//If the old task was finished, begin from scratch, 
			//otherwise continue where you stopped previously.
			if (m_enmStatus==EStatus.enmWorkCompleted) 
				m_bytProgress=0;
			m_enmStatus=EStatus.enmWorkStarted;
			//Tell everybody in the receiver list the about the change of status
			//From now on, the progress counter should be increased
			//by using an internal timer
			m_timer.Start(); 
		}
		/// <summary>
		/// Tells the worker to stop working
		/// </summary>
		public void StopWork()
		{
			m_timer.Stop();
			m_lngLastStopTime=DateTime.Now.Ticks;
			m_tsLastExecutionTime=TimeSpan.FromTicks(m_lngLastStopTime-m_lngLastStartTime);
			m_enmStatus= m_bytProgress <100 ? EStatus.enmIdle : EStatus.enmWorkCompleted;
			//Tell everybody in the receiver list the change of status.
			if (status != null)
				status (this, m_enmStatus);
			else
				Console.WriteLine ("Noone wants to be informed about the status of the worker");
			//Write out the execution Time
			Console.WriteLine ("Execution Time until work completion " +
							   "(including all Notifications): " + 
							   m_tsLastExecutionTime.ToString());
				
		}
		/// <summary>
		/// A timer simulates the progress of the work. 
		/// This method implements a handler for the timer event: 
		/// Shows the progress of work by incrementing the percentage by 10%
		/// each time the timer elapses, until 100% are reached.
		/// </summary>
		/// <param name="sender">The timer that has raised the event</param>
		/// <param name="e">The event arguments provided by the sending timer </param>
		private void OnTimerElapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			m_enmStatus=EStatus.enmWorkInProgress;
			if (m_bytProgress < 100) m_bytProgress+=10; //Increase the progress percentage
			//Notify everybody in the receiver list about the new percentage 		
			if (progress != null)
			{
				EFeedback enmFeedback = progress (this, m_bytProgress);
				//Write out the feedback. Please note that it cannot be determined who has sent the feedback 
				Console.WriteLine("The feedback was {0}", enmFeedback.ToString());
			}
			else
			{
				Console.WriteLine ("Noone wants to be informed about the progress of the work");
			}
			//Automatically stop working if work is done ;-)
			if (m_bytProgress>=100 && m_timer.Enabled) this.StopWork();  
		}
	}
}
