using System;

namespace Delegates
{
	/// <summary>
	/// A Boss is a Person with the special ability to be notified about status and progress of work.
	/// To do this, it implements the ReportProgress and ShowStatus functions.
	/// </summary>
	public class CBoss : CPerson
	{
		#region ctors
		public CBoss():this("", "")
		{}
		public CBoss(string strFirstName, string strLastName):this(strFirstName, strLastName, DateTime.Today)
		{}
		public CBoss(string strFirstName, string strLastName, DateTime dtDateOfBirth):base(strFirstName, strLastName, dtDateOfBirth)
		{
		}
		#endregion
		/// <summary>
		/// Is called when a worker makes progress
		/// </summary>
		/// <param name="sender">The worker who has sent the progress update</param>
		/// <param name="e">Event Args with the current progress of the work as "percentage completed"</param>
		/// <returns>The "satisfaction level" of the boss</returns>
		public EFeedback ProgressChangeReceiver(CWorker sender, ProgressChangeEventArgs e)
		{  
			Console.WriteLine("{0} {1} has been notified that {2} has done {3} percent of his work", this.FirstName, this.LastName, sender.FirstName, e.PercentComplete.ToString());
			System.Threading.Thread.Sleep(TimeSpan.FromSeconds(3));
			if (e.PercentComplete >40 && e.PercentComplete <100)
				return EFeedback.enmTooSlow;
			if (e.PercentComplete >=100)
				return EFeedback.enmItsAboutTime;
			else	
				return EFeedback.enmNotInterested;
		}
		/// <summary>
		/// Is called when a worker's status changes
		/// </summary>
		/// <param name="sender">The worker who has sent the status update</param>
		/// <param name="e">Event Args with the worker's new status</param>
		public void StatusChangeReceiver(CWorker sender, StatusChangeEventArgs e)
		{
			Console.WriteLine("{0} {1}, the boss, has been notified that the worker {2}'s status has changed to {3}\n", this.FirstName, this.LastName, sender.FirstName, e.Status.ToString());
		}

	}
}
