using System;

namespace Delegates
{
	/// <summary>
	/// The entry point for everything
	/// </summary>
	class CUniverse
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			//The bosses are born
			CBoss bill = new CBoss("Bill", "Gates", DateTime.Parse("12.07.1962"));
			CBoss gisella = new CBoss("Gisella", "Rader", DateTime.Parse("24.07.1971"));
			//The worker is born
			CWorker michael = new CWorker ("Michael", "Rader", DateTime.Parse("18.12.1969"));
			//The worker's dog is born
			CDog hasso = new CDog("Hasso", "Yorkshire Terrier");

			//The universe wants to know everything
			michael.ProgressChange += new ProgressChangeEventHandler (CUniverse.ProgressChangeReceiver);
			michael.StatusChange += new StatusChangeEventHandler (CUniverse.StatusChangeReceiver);
			//bill wants to be notified about michaels work progress and status
			michael.ProgressChange += new ProgressChangeEventHandler(bill.ProgressChangeReceiver);
			michael.StatusChange += new StatusChangeEventHandler(bill.StatusChangeReceiver);
			//gisella also wants to be notified about michaels work progress and status
			michael.ProgressChange += new ProgressChangeEventHandler(gisella.ProgressChangeReceiver);
			michael.StatusChange += new StatusChangeEventHandler(gisella.StatusChangeReceiver);
			//michaels dog only cares about michaels status and not his progress
			michael.StatusChange += new StatusChangeEventHandler(hasso.StatusChangeReceiver);
			//michael.progress=null;				//This won't be allowed anymore!
			//michael.progress (michael, 100);		//This won't be allowed anymore!
			michael.StartWork(); //Michael starts working
			//now look whats happening
			Console.ReadLine ();
		}
		private static void StatusChangeReceiver (CWorker sender, StatusChangeEventArgs e)
		{
			Console.WriteLine ("The universe recognized a status change for {0} {1} to {2}",
				sender.FirstName, sender.LastName, e.Status.ToString ());
		}
		private static EFeedback ProgressChangeReceiver (CWorker sender, ProgressChangeEventArgs e)
		{
			Console.WriteLine ("The universe recognized the progress from {0} {1} 's work to {2} percent",
				sender.FirstName, sender.LastName, e.PercentComplete.ToString());
			System.Threading.Thread.Sleep(TimeSpan.FromSeconds(3));
			return EFeedback.enmNotInterested;
		}
	}
}
