package org.demo.ejb;

import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

public class StockManagerClient {

    public static final String DEFAULT_URL =
        "http://localhost:8888/stockmanager/stockmanager";

    public static void main(String[] args) throws Exception {
        String address = DEFAULT_URL;
        if (args != null && args.length > 0) {
            address = args[0];
        }
        ServiceFactory factory = ServiceFactory.newInstance();

        QName portQname =
            new QName("http://oracle.j2ee.ws/ejb/Hello", "StockManagerWSPort");

        // Load ejb WebSerivce client-side proxy(stub).
        Service service =
            factory.loadService(
                new URL(address + "?WSDL"),
                StockManagerEJB.class,
                null);
        StockManagerWS serviceInf =
            (StockManagerWS) service.getPort(portQname, StockManagerWS.class);
        System.out.println("Infineon: " + serviceInf.getQuote("1234"));
    }
}
