using System;
using System.Windows.Forms;
using Office = Microsoft.Office.Core;
using Excel = Microsoft.Office.Interop.Excel;
using MSForms = Microsoft.Vbe.Interop.Forms;

// Office-Integrationsattribut. Gibt die Startklasse fr die Arbeitsmappe an. Nicht ndern.
[assembly:System.ComponentModel.DescriptionAttribute("OfficeStartupClass, Version=1.0, Class=VSTO_Excel1.OfficeCodeBehind")]

namespace VSTO_Excel1
{
    /// <summary>
    /// Enthlt verwaltete Codeerweiterungen fr die Arbeitsmappe.
    /// </summary>
    public class OfficeCodeBehind
    {
        
        /// <summary>
        /// Anwendungsobjekt.
        /// </summary>
        internal Excel.Application ThisApplication
        {
            get { return thisApplication;}
        }

        /// <summary>
        /// Arbeitsmappenobjekt.
        /// </summary>
        internal Excel.Workbook ThisWorkbook
        {
            get { return thisWorkbook;}
        }

        private Excel.Application thisApplication = null;
        private Excel.Workbook thisWorkbook = null;

        private Excel.WorkbookEvents_OpenEventHandler openEvent;
        private Excel.WorkbookEvents_BeforeCloseEventHandler beforeCloseEvent;

        #region Generierter Initialisierungscode

        /// <summary>
        /// Standardkonstruktor.
        /// </summary>
        public OfficeCodeBehind()
        {
        }

        /// <summary>
        /// Erforderliche Prozedur. Nicht ndern.
        /// </summary>
        /// <param name="application">Anwendungsobjekt.</param>
        /// <param name="workbook">Arbeitsmappenobjekt.</param>
        public void _Startup(object application, object workbook)
        {
            this.thisApplication = application as Excel.Application;
            this.thisWorkbook = workbook as Excel.Workbook;

            openEvent= new Excel.WorkbookEvents_OpenEventHandler (ThisWorkbook_Open);
            thisWorkbook.Open += openEvent;
            
            beforeCloseEvent = new Excel.WorkbookEvents_BeforeCloseEventHandler(ThisWorkbook_BeforeClose);
            thisWorkbook.BeforeClose += beforeCloseEvent;
        }

        /// <summary>
        /// Erforderliche Prozedur. Nicht ndern.
        /// </summary>
        public void _Shutdown()
        {
            thisApplication = null;
            thisWorkbook = null;
        }

        /// <summary>
        /// Sucht das Steuerelement mit dem angegebenen Namen in der aktiven Arbeitsmappe.
        /// </summary>
        /// <param name='name'>Name des zu suchenden Steuerelements.</param>
        /// <returns>
        /// Gibt das angegebene Steuerelement zurck, bzw. 'NULL', wenn dieses nicht gefunden wurde.
        /// </returns>
        object FindControl(string name )
        {
            return FindControl(name, (Excel.Worksheet) ThisWorkbook.ActiveSheet);
        }

        /// <summary>
        /// Gibt das Steuerelement mit dem angegebenen Namen in der angegebenen Arbeitsmappe zurck.
        /// </summary>
        /// <param name='name'>Name des zu suchenden Steuerelements.</param>
        /// <param name='sheet'>Arbeitsmappenobjekt, das das Steuerelement enthlt.</param>
        /// <returns>
        /// Gibt das angegebene Steuerelement zurck, bzw. 'NULL', wenn dieses nicht gefunden wurde.
        /// </returns>
        object FindControl(string name, Excel.Worksheet sheet ) 
        {
            Excel.OLEObject theObject;
            try
            {
                theObject = (Excel.OLEObject) sheet.OLEObjects(name);
                return theObject.Object;
            }
            catch
            {
                // Gibt 'NULL' zurck, wenn das Steuerelement nicht gefunden wurde.
            }
            return null;
        }

        #endregion

        /// <summary>
        /// Aufruf erfolgt beim ffnen der Arbeitsmappe.
        /// </summary>
        protected void ThisWorkbook_Open()
        {
        ((Excel.Worksheet) this.thisApplication.ActiveWorkbook.ActiveSheet).get_Range("A1","C10").Borders.Color = 12;
          System.Windows.Forms.MessageBox.Show("test");
        }

        /// <summary>
        /// Wird vor dem Schlieen der Arbeitsmappe aufgerufen. Diese Methode kann
        /// mehrmals aufgerufen werden, und der zu 'Cancel' zugewiesene Wert
        /// kann ignoriert werden, falls anderer Code oder der Benutzer eingreift.
        /// </summary>
        /// <param name="Cancel">'False', wenn das Ereignis eintritt. Falls der Ereignisvorgang
        /// dies als 'True' festlegt, wird das Dokument am Ende des Vorgangs nicht geschlossen.
        /// </param>
        protected void ThisWorkbook_BeforeClose(ref bool Cancel)
        {
            Cancel = false;
        }


    }
}
