using System;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.Serialization.Formatters.Soap;
using System.Runtime.Serialization;
using System.IO;
using System.Xml.Serialization;
using System.Xml;
using System.Data;

namespace de.itv
{

	// Hilfsfunktionen fr Serialisierung
	public class SerializationHelper 
	{

		public static void Bin_Serialize(object o, string datei) 
		{

			// Serialisieren in Binrdatei
			BinaryFormatter form = new BinaryFormatter();

			FileStream stream = new FileStream(datei, FileMode.Create, FileAccess.Write, FileShare.None);

			form.Serialize(stream, o);
			stream.Close();
				}


		public static byte[] Bin_Serialize(object o) 
		{

			// Serialisieren in Bytefolge
			BinaryFormatter form = new BinaryFormatter();
			MemoryStream stream = new MemoryStream();
			form.Serialize(stream, o);
			stream.Close();
	
			return (stream.ToArray());
		}


		public static object Bin_Deserialize(string datei) 
		{

			// Deserialisieren aus einer Binrdatei
			BinaryFormatter form = new BinaryFormatter();
			FileStream stream = new FileStream(datei, FileMode.Open);
			object o = form.Deserialize(stream);
			stream.Close();

			return o;
		}


		public static object Bin_Deserialize(byte[] ba) 
		{

			// Deserialisieren aus einer Bytefolge
			BinaryFormatter form = new BinaryFormatter();
			MemoryStream stream = new MemoryStream(ba);
			object o = form.Deserialize(stream);
			stream.Close();

			return o;
		}


		public static void Soap_Serialize(object o, string datei) 
		{

			// SOAP-Serialisierung in Binrdatei
			SoapFormatter form = new SoapFormatter();
			FileStream stream = new FileStream(datei, FileMode.Create, FileAccess.Write, FileShare.None);
			form.Serialize(stream, o);
			stream.Close();

		}


		public static object Soap_Deserialize(string datei) 
		{

			// SOAP-Deserialisieren aus einer Binrdatei
			SoapFormatter form = new SoapFormatter();
			FileStream stream = new FileStream(datei, FileMode.Open);
			object o = form.Deserialize(stream);
			stream.Close();

			return o;
		}


		public static void Xml_Serialize(object obj, string datei) 
		{

			// Serialisieren in XML-Datei
			XmlSerializer serializer = new XmlSerializer(obj.GetType());
			StreamWriter writer = new StreamWriter(datei);
			serializer.Serialize(writer, obj);
			writer.Close();

		}


		public static object Xml_Deserialize(Type t, string datei) 
		{

			// Deserialisieren aus XML-Datei
			StreamReader reader = new StreamReader(datei);
			XmlSerializer serializer = new XmlSerializer(t);
			object obj = serializer.Deserialize(reader);

			reader.Close();
			return (obj);
		}


		public static string Xml_Serialize(object obj) 
		{

			// XML-Serialisieren in String
			XmlSerializer serializer = new XmlSerializer(obj.GetType());

			// Serialisieren in MemoryStream
			MemoryStream ms = new MemoryStream();
			serializer.Serialize(ms, obj);


			// Stream in String umwandeln   
			StreamReader r = new StreamReader(ms);
			r.BaseStream.Seek(0, SeekOrigin.Begin);

			return r.ReadToEnd();
		}


		public static string MS_To_String(MemoryStream ms) 
		{

			// Zeichenweise Umwandlung eines Memory-Streams in einen String
			string s = String.Empty;
			byte[] ba = ms.ToArray();
			foreach (byte b in ba) 
			{
				s += (char)b;
			}
			return s;
		}


		public static object Xml_Deserialize_String(Type t, string s) 
		{

			// Deserialisieren aus XML-String
			object obj;

			// Objekt in Stream kopieren
			MemoryStream stream = new MemoryStream();
			StreamWriter w = new StreamWriter(stream);
			w.BaseStream.Seek(0, SeekOrigin.End);
			w.WriteLine(s);
			w.Close();

			// Stream umkopieren, weil jetzt geschlossen
			stream = new MemoryStream(stream.ToArray());
			XmlSerializer serializer = new XmlSerializer(t);
			obj = serializer.Deserialize(stream);

			stream.Close();

			return (obj);
		}
	}
}
