/*
 * ToggleContributorsBuilderAction.java
 *
 * Copyright (c) 2003 Peter Friese
 * All rights reserved.
 *  
 */
package de.heise.ix.builders;

import java.util.Iterator;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

import de.heise.ix.builders.nature.NatureManager;

/**
 * The class ToggleContributorsBuilderAction is responsible for ...
 * TODO Enter purpose of class, please!
 * 
 * @author Peter Friese
 */
public class ToggleContributorsBuilderAction implements IActionDelegate {

	private IStructuredSelection selection;

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (!selection.isEmpty()) {
			for (Iterator iter = selection.iterator(); iter.hasNext();) {
				Object obj = (Object) iter.next();
				if (obj instanceof IJavaProject) {
					IJavaProject javaProject = (IJavaProject) obj;
					IProject project = javaProject.getProject();
					System.out.println("Project name: " + project.getProject().getName());
					if (project != null) {
						Shell shell = ContributorsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
						NatureManager manager = new NatureManager(shell, project);
						if (manager.isNatureEnabled()) {
							manager.removeNature();
						}
						else {
							manager.addNature();
						}
					}
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
			
		}
	}

}
