/*
 * ContributorsFile.java
 *
 * Copyright (c) 2003 Peter Friese
 * All rights reserved.
 *  
 */
package de.heise.ix.builders.contributors;

import java.io.*;
import java.util.*;

/**
 * Die Klasse <code>ContributorsFile</code> kapselt den
 * Zugriff auf die Datei CONTRIBUTORS, die die Liste 
 * der Autoren des Projekts enthlt.
 * 
 * @author Peter Friese
 */
public class ContributorsFile {

	/** Liste der Autoren */
	private HashMap contributors = new HashMap();

	/**
	 * Liest die Datei mit der Liste der Autoren ein.
	 * 
	 * @param inputStream Ein geffneter 
	 * 	{@link InputStream} auf die Datei CONTRIBUTORS.
	 * @throws IOException Wenn ein I/O Fehler auftritt.
	 */
	public void scanFile(InputStream inputStream)
		throws IOException {
		if (inputStream != null) {
			InputStreamReader isReader =
				new InputStreamReader(inputStream);
			BufferedReader bufReader =
				new BufferedReader(isReader);
			String line;
			while (((line = bufReader.readLine())
				!= null)) {
				scanLine(line);
			}
		}
	}

	/**
	 * Erzeugt aus der bergebenen Zeile ein 
	 * {@link Contributor} Objekt.
	 *  
	 * @param line Die aktuelle Zeile.
	 */
	private void scanLine(String line) {
		String name = line;

		Contributor contributor = new Contributor();
		contributor.setName(name);

		if (!contributors.containsKey(name)) {
			contributors.put(name, contributor);
		}
	}

	/**
	 * Fgt einen Autoren hinzu.
	 * 
	 * @param contributor Ein Autor.
	 */
	public void addContributor(Contributor contributor) {
		if (!contributors
			.containsKey(contributor.getName())) {
			contributors.put(
				contributor.getName(),
				contributor);
		}
	}

	/**
	 * Schreibt die Liste der Autoren in den bergebenen
	 * {@link OutputStream}.
	 * 
	 * @param outputStream Ein geffneter 
	 * 	<code>OutputStream</code>.
	 * @throws IOException Wenn ein I/O-Fehler auftritt. 
	 */
	public void writeFile(OutputStream outputStream)
		throws IOException {
		
		// erstmal sortieren...
		ArrayList contributorNames = new ArrayList();
		for (Iterator sortIter =
			contributors.values().iterator();
			sortIter.hasNext();
			) {
			Contributor contributor =
				(Contributor) sortIter.next();
			contributorNames.add(contributor.getName());
		}
		Collections.sort(contributorNames);

		// dann schreiben!
		BufferedWriter writer =
			new BufferedWriter(
				new OutputStreamWriter(outputStream));
		Iterator writeIter = contributorNames.iterator();
		while (writeIter.hasNext()) {
			String contributor = (String) writeIter.next();
			writer.write(contributor + "\n");
		}
		writer.close();
	}

}
