/*
 * BaseDetector.java
 *
 * Copyright (c) 2003 Peter Friese
 * All rights reserved.
 *  
 */
package de.heise.ix.builders.scanner;

import java.util.ArrayList;
import java.util.Collection;

/**
 * The class BaseDetector is responsible for ...
 * TODO Enter purpose of class, please!
 * 
 * @author Peter Friese
 */
public abstract class BaseDetector {
	
	private FileScanner scanner;
	protected Collection resultCollection = new ArrayList();
	
	/**
	 * This method must return the name of the detector.
	 * @return The name of the detector.
	 */
	public abstract String getDetectorName();
	
	public abstract void detect(String line);
	
	public Collection getResult() {
		return resultCollection;
	}

	/**
	 * Sets a reference to thw owning scanner.
	 * @param scanner The owning scanner.
	 */
	public void setScanner(FileScanner scanner) {
		this.scanner = scanner;
	}

}
