/*
 * FileScanner.java
 *
 * Copyright (c) 2003 Peter Friese
 * All rights reserved.
 *  
 */
package de.heise.ix.builders.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * The class FileScanner is responsible for ...
 * TODO Enter purpose of class, please!
 * 
 * @author Peter Friese
 */
public class FileScanner {
	
	private InputStream inputStream;
	private Map detectors;

	public FileScanner(InputStream inputStream) {
		this.inputStream = inputStream;
		this.detectors = new HashMap();
	}
	
	/** 
	 * Scans the whole file.
	 */
	public void scan() throws IOException {
		InputStreamReader isReader = new InputStreamReader(inputStream);
		BufferedReader bufReader = new BufferedReader(isReader);
		String line;
		while ( ( (line = bufReader.readLine()) != null) ) {
			detect(line);
		}
	}

	protected void detect(String line) {
		Iterator iter = detectors.values().iterator();
		while (iter.hasNext()) {
			BaseDetector detector = (BaseDetector) iter.next();
			detector.detect(line);
		}
	}
	
	public void addDetector(BaseDetector detector) {
		if (detector == null) {
			throw new NullPointerException("Detector must not be null!");
		}
		else {
			if (detectors.containsKey(detector.getDetectorName())) {
				// throw new DuplicateKeyException("Duplicate key.");
			}
			else {
				detector.setScanner(this);
				detectors.put(detector.getDetectorName(), detector);
			}
		}
	}
	
	public Collection getResult(String detectorName) {
		BaseDetector detector = (BaseDetector) detectors.get(detectorName);
		return 
			(detector == null)
				? new ArrayList()
				: detector.getResult();
	}
	
}
