/* TodayPortlet
 * Ein JSR 168-kompatibles Portlet zur Anzeige des Tagesdatums.
 * (vgl. Artikel "Porta(be)l", iX 09/2004)
 * 
 * TodayPortlet.java 
 *  
 * Copyright (c) 2004 Holger Koschek <hk@thinkopen.de>.
 */
package de.thinkopen.portlet.portlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * TodayPortlet ist von der abstrakten Standardklasse GenericPortlet
 * abgeleitet; es erbt ein Rendering-Standardverhalten sowie den
 * automatischen Aufruf von doView(), doEdit() bzw. doHelp() aus
 * doDispatch() heraus - abhaengig vom Portlet-Modus.    
 */
public class TodayPortlet extends GenericPortlet {

	private SimpleDateFormat dateformat;

	public void init() throws PortletException {
		// Delegieren der Initialisierung an GenericPortlet.
		super.init();

		// Deutsches Datumsformat fuer die Textausgabe.
		dateformat = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
	}

	protected void doView(RenderRequest request, RenderResponse response)
		throws PortletException, IOException {

		// Das Portlet liefert HTML-Markup.
		response.setContentType("text/html");

		// Alles, was an das per getWriter() vom RenderResponse-Objekt bezogene
		// PrintWriter-Objekt geschrieben wird, wird Bestandteil des Portlet-
		// Fragments (d.h. der Bildschirmausgabe des Portlets).
		PrintWriter out = response.getWriter();
		out.print("<h3>" + this.dateformat.format(new Date()) + "</h3>");
	}
}
