using System;
using System.Web.Services;
using System.Xml.Serialization;

namespace innoQ {
 namespace WebServices {
  namespace Secure {
   public class KreditkartenService {

    /**
     * Belastet die Kreditkarte, die durch die
     * KreditkartenInfo definiert ist, um den
     * gegebenen Betrag in der gegebenen Whrung.
     * Liefert true wenn die Kreditkarte akzeptiert
     * wird, false sonst.
     */			 
	 [WebMethod]
	 public Boolean belasteKreditkarte(
	            KreditkartenInfo pKreditkartenInfo,
	            Double pBetrag,
	            String pWaehrung) { 
        // Normalerweise luft hier eine Menge
        // Businesslogik ab. Um das zu vereinfachen
        // wird hier nur die Gltigkeit der Kreditkarte
        // abgefragt.
        DateTime heute = DateTime.Now;
        if (heute.CompareTo(pKreditkartenInfo.gueltigVon)>=0 &&
            heute.CompareTo(pKreditkartenInfo.gueltigBis)<=0) {
            Console.WriteLine("Kreditkarte gltig!");
            return true;
        }
        Console.WriteLine("Kreditkarte ungltig!");
        return false;
     }
	}
	
	public class KreditkartenInfo {
	    public string nummer;
	    public string name;
	    public DateTime gueltigVon;
	    public DateTime gueltigBis;
	}
  }
 }
}
