<%@ page language="C#" masterpagefile="~/Master/itv.master" %>
<%@ register tagprefix="uc1" tagname="ObjectDetails" src="~/_Controls/ObjectDetails.ascx" %>
<%@ OutputCache Duration="10"  VaryByParam="none" DiskCacheable="true"%>

<script runat="server" language="c#">

    public static string GetAnmeldeDauer(HttpContext context)
    {
      //  TimeSpan t = System.DateTime.Now.Subtract(Convert.ToDateTime(context.Session["SessionStart"]));
    TimeSpan t = System.DateTime.Now.Subtract(Membership.GetUser(context.User.Identity.Name).LastLoginDate);

        return "<i>" + t.Seconds.ToString() + "</i> Sekunden";
    }
 
 void Page_Load(object sender, System.EventArgs e)
 {
     this.C_Wohnort.Text = Profile.Adresse.Postleitzahl + " " + Profile.Adresse.Ort;

     MembershipUser u = Membership.GetUser(this.User.Identity.Name);
     if (u != null)
     {
         C_Rollen.DataSource = Roles.GetRolesForUser(u.UserName);
         C_Rollen.DataBind();
     }
    
     if (!Page.IsPostBack) C_Theme.Items.FindByText(this.Theme).Selected = true;
 }
 
  
 void C_Theme_SelectedIndexChanged(object sender, System.EventArgs e)
 {
        
  Profile.Layout.Theme = C_Theme.SelectedValue;  
  this.Response.Redirect(this.Request.RawUrl, true);
  }
  
 
 void Page_PreInit(object sender, System.EventArgs e)
 {
  this.Theme = Profile.Layout.Theme;
     

 }
 
</script>
<asp:content id="Content1" contentplaceholderid="P_MainContent" runat="server">
    <br />
    Sie sind angemeldet seit:
    <asp:Substitution ID="Substitution1" Runat="server" MethodName="GetAnmeldeDauer" />
    <br />
    <br />
    Ihr gespeicherter Wohnort:
    <asp:Label ID="C_Wohnort" Runat="server"></asp:Label>
    <br />
    <br />
 Sind sind Mitglied in folgenden Rollen:<br />
 <asp:bulletedlist id="C_Rollen" runat="server">
 </asp:bulletedlist>&nbsp;
    <br />
 
 Ihr persnliches Layout: <asp:dropdownlist id="C_Theme" runat="server" autopostback="true" onselectedindexchanged="C_Theme_SelectedIndexChanged">
 <asp:listitem>Standard</asp:listitem>
 <asp:listitem>Rot</asp:listitem>
 <asp:listitem>Gruen</asp:listitem>
 </asp:dropdownlist>
    <br />
 

 <br />
</asp:content>

