package VCSSelectors;

import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

import org.apache.tools.ant.BuildException;

/** This class is a concrete Selektor for the 
 * CVS System
 *
 * @author Torsten Gonther
 */
public class CVSSelector extends AbstractVCSSelector {
	
	private String[] cmdLine;
	
	private String cvsFile, cvsStatus,
 		cvsVersion, cvsStickyTag;
	private Hashtable cvsTags, cvsBranches; 
	
	/** Runs the command "cvs status options file" 
	 * and returns the output as string.
	 * @param fi
	 * @return
	 */
	private String runCVSstatus(File fi) {

		cmdLine = new String[4];

		cmdLine[0] = "cvs";
		cmdLine[1] = "status";
		cmdLine[2] = "-v";
		cmdLine[3] = fi.getName();
		StringBuffer out;
		try {
			//Run a cvs status file and check the output
			Process pr = Runtime.getRuntime().
				exec(cmdLine, null, fi.getParentFile());
			//Get the Process's output
			InputStream is = pr.getInputStream();
			out = new StringBuffer("");
			int ch = is.read();
			while (ch != -1) {
				out.append((char) ch);
				ch = is.read();
			}
			//Check the exit code
			int retState = pr.waitFor();
			if (retState != 0) {
				StringBuffer sb = new StringBuffer("");
				for (int ix=0; ix < cmdLine.length; ix++)
					sb.append(cmdLine[ix]);
				throw new BuildException("Command >" + sb + 
					"< returned status" + retState);
			}
		} catch (Exception exc) {
			throw new BuildException(exc.toString());
		}
	
		return out.toString();
	}
	
	private void scanCVSStatusOutput(String cvsOut) {
		cvsFile = cvsStatus 
			= cvsVersion = cvsStickyTag = null;
		cvsTags = new Hashtable();
		cvsBranches = new Hashtable();
		StringTokenizer tok = new StringTokenizer(
			cvsOut, System.getProperty("line.separator"));
		while (tok.hasMoreTokens()) {
			String line = tok.nextToken().trim();
			if (line.startsWith("File:")) {
				String[] fields = line.trim().split("\\s");
				cvsFile = fields[1];
				cvsStatus = fields[3];
			} else if (line.startsWith("Working revision:")) {
				String[] fields = line.trim().split("\\s");
				cvsVersion = fields[2];
			} else if (line.startsWith("Sticky Tag:")) {
				String[] fields = line.trim().split("\\s");
				cvsStickyTag = fields[3];
			} else if (line.startsWith("Existing Tags:")) {
				while (tok.hasMoreTokens()) {
					line = tok.nextToken().replaceAll("\\s+", " ");
					String[] fields = line.trim().split("\\s");
					if (fields[1].indexOf("branch") != -1)
						cvsBranches.put(fields[0], 
							fields[2].substring
								(0, fields[2].length()-1));
					else if (fields[1].indexOf("revision") != -1)
						cvsTags.put(fields[0], 
							fields[2].substring
								(0, fields[2].length()-1));
				}				
			}
		}
	}
	
	public boolean checkIsVCSFile(File file) {
		String cvsOut = runCVSstatus(file);
		if (cvsOut.indexOf
			("No entry for "+file.getName()) >= 0 )
			return false;
		return true;	
	}
	
	public boolean checkTag(String tag, File file) {
		if ((tag == null) || (file == null))
			return false; 
		String cvsOut = runCVSstatus(file);
		scanCVSStatusOutput(cvsOut);
		if (cvsTags.containsKey(tag) && 
			cvsTags.get(tag).equals(cvsVersion))
			return true;
		return false;
	}
	
	public boolean checkVersion(String version, File file) {
		if ((version == null) || (file == null))
			return false;
		String cvsOut = runCVSstatus(file);
		scanCVSStatusOutput(cvsOut);
		if (cvsVersion.equals(version))
			return true;
		return false;
	}
	
	public boolean checkBranch(String branch, File file) {
		if ((branch == null) || (file == null))
			return false;
		String cvsOut = runCVSstatus(file);
		scanCVSStatusOutput(cvsOut);
		if (branch.equalsIgnoreCase("main")) {
			return  new StringTokenizer(cvsVersion, ".")
				.countTokens() == 2;
		} else if (cvsStickyTag.equals(branch) && 
			cvsBranches.containsKey(branch))
			return true;
		return false;
	}
	
}



