﻿using System;
using System.Collections.Generic;
using System.Text;
using de.ITVisions.DemoViewer;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;

namespace N2C.ADONET
{
 [Demo]
 class Command
 {

  // === SQL-Befehle in einer Transaktion ausführen
  public void ADONET_Transaction_Demo()
  {
   Demo.PrintHeader("Command-Transaction-Demo");

   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=WorldWideWings;Data Source=MARL\sqlexpress";
   const string SQL1 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_FlugDatum], [GF_Preis], [GF_Klasse]) " +
    "VALUES (1, 101, 8/1/2005, 500, 'F')";
   const string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_FlugDatum], [GF_Preis], [GF_Klasse]) " +
    "VALUES (1, 203, 8/1/2005, 500, 'F')"; // Erfolgreicher Befehl
   //const string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_FlugDatum], [GF_Preis], [GF_Klasse]) " +
   // "VALUES (1, 203, 8/1/2005, 500, 'FFF')"; // Zum Testen: Fehlerhafter Befehl
   const string SQL3 = "Select count(*) from GF_GebuchteFluege";
   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();

   // Befehlsobjekt erzeugen
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL3;
   Demo.Print("Anzahl Datensätze vorher: " + sqlCmd.ExecuteScalar().ToString());
   SqlTransaction t = null;
   try
   {
    t = sqlConn.BeginTransaction();
    sqlCmd.CommandText = SQL1;
    sqlCmd.Transaction = t;
    Demo.Print(SQL1);
    Demo.Print("Betroffene Zeilen: " + sqlCmd.ExecuteNonQuery());
    sqlCmd.CommandText = SQL2;
    sqlCmd.Transaction = t;
    Demo.Print(SQL2);
    Demo.Print("Betroffene Zeilen: " + sqlCmd.ExecuteNonQuery());
    t.Commit();
    Demo.Print("Transaktion erfolgreich ausgeführt!");
   }
   catch (Exception ex)
   {
    t.Rollback();
    Demo.Print("Transaktion fehlgeschlagen: " + ex.Message);
   }
   finally
   {
    sqlCmd.CommandText = SQL3;
    Demo.Print("Anzahl Datensätze nachher: " + sqlCmd.ExecuteScalar().ToString());
    sqlConn.Close();
   }
  }
 }
}
