// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================
using System;
using System.Data.SqlClient;
using System.Data.Sql;
using System.Data;
using de.ITVisions.DemoViewer;

namespace NET2
{
 [Demo]
 public class AsyncCommand
 {

  public void run_Callback()
  {
   Console.WriteLine("Asynchrone Ausfhrung - Callback-Modell");

   //Asynchronous Processing=true

   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Async=true;Initial Catalog=worldwidewings;Data Source=Marl\sqlexpress";
   const string SQL = "Select * from Fl_Fluege";

   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   
   AsyncCallback callback = new AsyncCallback(CallbackHandler);
   sqlCmd.BeginExecuteReader(callback, sqlCmd, CommandBehavior.CloseConnection);
//   sqlCmd.Cancel(); Beta 1: Not supported
   for (int a = 0; a <= 200; a++) { 
    Console.WriteLine(a); 
    System.Windows.Forms.Application.DoEvents(); 
   }
}

  //sqlCmd.Cancel();

  private static void CallbackHandler(IAsyncResult result)
  {
   Console.WriteLine("Callback von asynchronem Reader-Aufruf...");
   SqlCommand command = (SqlCommand)result.AsyncState;
   SqlDataReader reader = command.EndExecuteReader(result);

   Console.WriteLine("Hat der Befehl Zeilen geliefert? " + reader.HasRows);
// Ausgabe der Ergebnisse
   PrintReader(reader);
}

  // Asynchrone Befehlsausfhrung via Polling

  public void run_Polling()
  {
   Console.WriteLine("Asynchrone Ausfhrung - Polling");

   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Async=true;Initial Catalog=worldwidewings;Data Source=Marl\sqlexpress"; 
   const string SQL = "Select *from FL_Fluege";

   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   // Befehl definieren
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Befehl starten
   IAsyncResult result = sqlCmd.BeginExecuteReader(CommandBehavior.CloseConnection);
   // Warten...

   while (!result.IsCompleted) { Console.WriteLine("Polling..."); }
   // Ergebnis auswerten
   SqlDataReader reader = sqlCmd.EndExecuteReader(result);
   Console.WriteLine("Daten (Polling):");
   PrintReader(reader);
  }

  // Asynchrone Befehlsausfhrung via WaitHandler

  public void run_Warten()
  {
   Console.WriteLine("Asynchrone Ausfhrung - Wartemodell");

   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Async=true;Initial Catalog=worldwidewings;Data Source=Marl\sqlexpress";
   const string SQL = "Select * from FL_Fluege";

   // Verbindung aufbauen
   SqlConnection sqlConn = new SqlConnection(CONNSTRING);
   sqlConn.Open();
   // Befehl definieren
   SqlCommand sqlCmd = sqlConn.CreateCommand();
   sqlCmd.CommandText = SQL;
   // Befehl starten
   IAsyncResult result = sqlCmd.BeginExecuteReader(CommandBehavior.CloseConnection);
   // Warten...
   Console.WriteLine("jetzt warte ich...");
   result.AsyncWaitHandle.WaitOne();
   // Ergebnis auswerten
   SqlDataReader reader = sqlCmd.EndExecuteReader(result);
   Console.WriteLine("Daten (Wartemodell):");
   PrintReader(reader);
  }


  public static void PrintReader(IDataReader reader)
  {
   while (reader.Read())
    for (int i = 0; i < reader.FieldCount; i++)
     Console.WriteLine("Spalte: " + reader.GetName(i) + "\t = " + reader.GetValue(i));
  }

 }
}
