// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================

using System;
using System.Data;
using System.Data.Common;
using de.ITVisions.DemoViewer;
namespace NET2
{
 /// <summary>
 /// Summary description for Factory.
 /// </summary>
 [Demo]
 public class FactoryDemo
 {
  public void run()
  {
   Demo.PrintHeader("DEMO Provider Factory");
   const string PROVIDER = "System.Data.SqlClient";  // 
   // Provider=SQLOLEDB;
   const string CONNSTRING = @"Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=worldwidewings;Data Source=Marl\sqlexpress";
   const string SQL1 = "Select * from FL_Fluege1";
   const string SQL2 = "Select * from FL_Fluege_Backup1";

   // --- Factory erzeugen
   DbProviderFactory provider = DbProviderFactories.GetFactory(PROVIDER);
   // --- Verbindung aufbauen
   DbConnection conn = provider.CreateConnection();
   conn.ConnectionString = CONNSTRING;
   conn.Open();

   // --- Teil 1: DataReader
   // Befehl erzeugen
   DbCommand cmd = provider.CreateCommand();
   cmd.CommandText = SQL1;
   cmd.Connection = conn;
   // Befehl ausfhren
   DbDataReader reader = cmd.ExecuteReader();
   // Daten ausgeben
   Demo.PrintReader(reader);
   reader.Close();

   // --- Teil 2: DataSet
   // Befehl erzeugen
   DbCommand command = provider.CreateCommand();
   command.CommandText = SQL2;
   command.Connection = conn;
   // DataAdapter erzeugen
   DbDataAdapter adapter = provider.CreateDataAdapter();
   adapter.SelectCommand = command;
   // DataSet erzeugen
   DataSet ds = new DataSet();
   // DataSet befllen
   adapter.Fill(ds);
   // Daten ausgeben
   DataTable t = ds.Tables[0];
   Console.WriteLine("Anzahl Spalten: " + t.Columns.Count);
   Console.WriteLine("Anzahl Zeilen: " + t.Rows.Count);
   conn.Close();
}
 }
}
